/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.List;
import java.util.concurrent.locks.StampedLock;
import org.apache.bookkeeper.mledger.Position;
import org.apache.pulsar.broker.service.RedeliveryTracker;

public class InMemoryRedeliveryTracker
implements RedeliveryTracker {
    private Long2ObjectMap<Long2IntMap> trackerCache = new Long2ObjectOpenHashMap();
    private final StampedLock rwLock = new StampedLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int incrementAndGetRedeliveryCount(Position position) {
        int newCount;
        long stamp = this.rwLock.writeLock();
        try {
            Long2IntMap entryMap = (Long2IntMap)this.trackerCache.computeIfAbsent(position.getLedgerId(), k -> new Long2IntOpenHashMap());
            newCount = entryMap.getOrDefault(position.getEntryId(), 0) + 1;
            entryMap.put(position.getEntryId(), newCount);
        }
        finally {
            this.rwLock.unlockWrite(stamp);
        }
        return newCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRedeliveryCount(long ledgerId, long entryId) {
        int count;
        long stamp = this.rwLock.tryOptimisticRead();
        Long2IntMap entryMap = (Long2IntMap)this.trackerCache.get(ledgerId);
        int n = count = entryMap != null ? entryMap.get(entryId) : 0;
        if (!this.rwLock.validate(stamp)) {
            stamp = this.rwLock.readLock();
            try {
                entryMap = (Long2IntMap)this.trackerCache.get(ledgerId);
                count = entryMap != null ? entryMap.get(entryId) : 0;
            }
            finally {
                this.rwLock.unlockRead(stamp);
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Position position) {
        long stamp = this.rwLock.writeLock();
        try {
            Long2IntMap entryMap = (Long2IntMap)this.trackerCache.get(position.getLedgerId());
            if (entryMap != null) {
                entryMap.remove(position.getEntryId());
                if (entryMap.isEmpty()) {
                    this.trackerCache.remove(position.getLedgerId());
                }
            }
        }
        finally {
            this.rwLock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBatch(List<Position> positions) {
        if (positions == null) {
            return;
        }
        long stamp = this.rwLock.writeLock();
        try {
            for (Position position : positions) {
                Long2IntMap entryMap = (Long2IntMap)this.trackerCache.get(position.getLedgerId());
                if (entryMap == null) continue;
                entryMap.remove(position.getEntryId());
                if (!entryMap.isEmpty()) continue;
                this.trackerCache.remove(position.getLedgerId());
            }
        }
        finally {
            this.rwLock.unlockWrite(stamp);
        }
    }

    @Override
    public void clear() {
        long stamp = this.rwLock.writeLock();
        try {
            this.trackerCache.clear();
        }
        finally {
            this.rwLock.unlockWrite(stamp);
        }
    }
}

