/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.util;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class DaemonThreadFactory
implements ThreadFactory {
    private ThreadFactory defaultThreadFactory = Executors.defaultThreadFactory();
    private int priority = 5;

    public DaemonThreadFactory() {
    }

    public DaemonThreadFactory(int priority) {
        assert (priority >= 1 && priority <= 10);
        this.priority = priority;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread thread = this.defaultThreadFactory.newThread(r);
        thread.setDaemon(true);
        thread.setPriority(this.priority);
        return thread;
    }
}

