/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stream.storage.impl.cluster;

import com.google.common.base.Strings;
import java.net.URI;
import java.util.Optional;
import org.apache.bookkeeper.meta.zk.ZKMetadataDriverBase;
import org.apache.bookkeeper.stream.proto.cluster.ClusterMetadata;
import org.apache.bookkeeper.stream.storage.StorageConstants;
import org.apache.bookkeeper.stream.storage.api.cluster.ClusterInitializer;
import org.apache.bookkeeper.stream.storage.exceptions.StorageRuntimeException;
import org.apache.bookkeeper.stream.storage.impl.cluster.ZkClusterMetadataStore;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkClusterInitializer
implements ClusterInitializer {
    private static final Logger log = LoggerFactory.getLogger(ZkClusterInitializer.class);
    private final String zkExternalConnectString;

    public ZkClusterInitializer(String zkServers) {
        this.zkExternalConnectString = zkServers;
    }

    public boolean acceptsURI(URI metadataServiceUri) {
        return metadataServiceUri.getScheme().toLowerCase().startsWith("zk");
    }

    public boolean initializeCluster(URI metadataServiceUri, int numStorageContainers) {
        String zkInternalConnectString = ZKMetadataDriverBase.getZKServersFromServiceUri((URI)metadataServiceUri);
        Throwable throwable = null;
        try (CuratorFramework client = CuratorFrameworkFactory.newClient((String)this.zkExternalConnectString, (RetryPolicy)new ExponentialBackoffRetry(100, Integer.MAX_VALUE, 10000));){
            client.start();
            ZkClusterMetadataStore store = new ZkClusterMetadataStore(client, zkInternalConnectString, "/stream");
            try {
                ClusterMetadata metadata = store.getClusterMetadata();
                log.info("Loaded cluster metadata : \n{}", (Object)metadata);
                boolean bl = false;
                return bl;
            }
            catch (StorageRuntimeException sre) {
                block18: {
                    boolean bl;
                    block19: {
                        block20: {
                            if (!(sre.getCause() instanceof KeeperException.NoNodeException)) break block18;
                            String ledgersPath = metadataServiceUri.getPath();
                            Optional<Object> segmentStorePath = Strings.isNullOrEmpty((String)ledgersPath) || "/" == ledgersPath ? Optional.empty() : Optional.of(ledgersPath);
                            log.info("Initializing the stream cluster with {} storage containers with segment store path {}.", (Object)numStorageContainers, (Object)segmentStorePath.orElse(StorageConstants.getSegmentsRootPath("/stream")));
                            boolean initialized = store.initializeCluster(numStorageContainers, segmentStorePath);
                            log.info("Successfully initialized the stream cluster : \n{}", (Object)store.getClusterMetadata());
                            bl = initialized;
                            if (client == null) break block19;
                            if (throwable == null) break block20;
                            try {
                                client.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            break block19;
                        }
                        client.close();
                    }
                    return bl;
                }
                try {
                    throw sre;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
        }
    }
}

