/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.api.proto;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pulsar.common.api.proto.LightProtoCodec;
import org.apache.pulsar.common.api.proto.Subscription;

public final class CommandAddSubscriptionToTxn {
    private long requestId;
    private static final int _REQUEST_ID_FIELD_NUMBER = 1;
    private static final int _REQUEST_ID_TAG = 8;
    private static final int _REQUEST_ID_TAG_SIZE = LightProtoCodec.computeVarIntSize(8);
    private static final int _REQUEST_ID_MASK = 1;
    private long txnidLeastBits = 0L;
    private static final int _TXNID_LEAST_BITS_FIELD_NUMBER = 2;
    private static final int _TXNID_LEAST_BITS_TAG = 16;
    private static final int _TXNID_LEAST_BITS_TAG_SIZE = LightProtoCodec.computeVarIntSize(16);
    private static final int _TXNID_LEAST_BITS_MASK = 2;
    private long txnidMostBits = 0L;
    private static final int _TXNID_MOST_BITS_FIELD_NUMBER = 3;
    private static final int _TXNID_MOST_BITS_TAG = 24;
    private static final int _TXNID_MOST_BITS_TAG_SIZE = LightProtoCodec.computeVarIntSize(24);
    private static final int _TXNID_MOST_BITS_MASK = 4;
    private List<Subscription> subscriptions = null;
    private int _subscriptionsCount = 0;
    private static final int _SUBSCRIPTION_FIELD_NUMBER = 4;
    private static final int _SUBSCRIPTION_TAG = 34;
    private static final int _SUBSCRIPTION_TAG_SIZE = LightProtoCodec.computeVarIntSize(34);
    private int _bitField0;
    private static final int _REQUIRED_FIELDS_MASK0 = 1;
    private int _cachedSize;
    private ByteBuf _parsedBuffer;

    public boolean hasRequestId() {
        return (this._bitField0 & 1) != 0;
    }

    public long getRequestId() {
        if (!this.hasRequestId()) {
            throw new IllegalStateException("Field 'request_id' is not set");
        }
        return this.requestId;
    }

    public CommandAddSubscriptionToTxn setRequestId(long requestId) {
        this.requestId = requestId;
        this._bitField0 |= 1;
        this._cachedSize = -1;
        return this;
    }

    public CommandAddSubscriptionToTxn clearRequestId() {
        this._bitField0 &= 0xFFFFFFFE;
        return this;
    }

    public boolean hasTxnidLeastBits() {
        return (this._bitField0 & 2) != 0;
    }

    public long getTxnidLeastBits() {
        return this.txnidLeastBits;
    }

    public CommandAddSubscriptionToTxn setTxnidLeastBits(long txnidLeastBits) {
        this.txnidLeastBits = txnidLeastBits;
        this._bitField0 |= 2;
        this._cachedSize = -1;
        return this;
    }

    public CommandAddSubscriptionToTxn clearTxnidLeastBits() {
        this._bitField0 &= 0xFFFFFFFD;
        this.txnidLeastBits = 0L;
        return this;
    }

    public boolean hasTxnidMostBits() {
        return (this._bitField0 & 4) != 0;
    }

    public long getTxnidMostBits() {
        return this.txnidMostBits;
    }

    public CommandAddSubscriptionToTxn setTxnidMostBits(long txnidMostBits) {
        this.txnidMostBits = txnidMostBits;
        this._bitField0 |= 4;
        this._cachedSize = -1;
        return this;
    }

    public CommandAddSubscriptionToTxn clearTxnidMostBits() {
        this._bitField0 &= 0xFFFFFFFB;
        this.txnidMostBits = 0L;
        return this;
    }

    public int getSubscriptionsCount() {
        return this._subscriptionsCount;
    }

    public Subscription getSubscriptionAt(int idx) {
        if (idx < 0 || idx >= this._subscriptionsCount) {
            throw new IndexOutOfBoundsException("Index " + idx + " is out of the list size (" + this._subscriptionsCount + ") for field 'subscription'");
        }
        return this.subscriptions.get(idx);
    }

    public List<Subscription> getSubscriptionsList() {
        if (this._subscriptionsCount == 0) {
            return Collections.emptyList();
        }
        return this.subscriptions.subList(0, this._subscriptionsCount);
    }

    public Subscription addSubscription() {
        if (this.subscriptions == null) {
            this.subscriptions = new ArrayList<Subscription>();
        }
        if (this.subscriptions.size() == this._subscriptionsCount) {
            this.subscriptions.add(new Subscription());
        }
        this._cachedSize = -1;
        return this.subscriptions.get(this._subscriptionsCount++);
    }

    public CommandAddSubscriptionToTxn addAllSubscriptions(Iterable<Subscription> subscriptions) {
        for (Subscription _o : subscriptions) {
            this.addSubscription().copyFrom(_o);
        }
        return this;
    }

    public CommandAddSubscriptionToTxn clearSubscription() {
        for (int i = 0; i < this._subscriptionsCount; ++i) {
            this.subscriptions.get(i).clear();
        }
        this._subscriptionsCount = 0;
        return this;
    }

    public int writeTo(ByteBuf _b) {
        this.checkRequiredFields();
        int _writeIdx = _b.writerIndex();
        LightProtoCodec.writeVarInt(_b, 8);
        LightProtoCodec.writeVarInt64(_b, this.requestId);
        if (this.hasTxnidLeastBits()) {
            LightProtoCodec.writeVarInt(_b, 16);
            LightProtoCodec.writeVarInt64(_b, this.txnidLeastBits);
        }
        if (this.hasTxnidMostBits()) {
            LightProtoCodec.writeVarInt(_b, 24);
            LightProtoCodec.writeVarInt64(_b, this.txnidMostBits);
        }
        for (int i = 0; i < this._subscriptionsCount; ++i) {
            Subscription _item = this.subscriptions.get(i);
            LightProtoCodec.writeVarInt(_b, 34);
            LightProtoCodec.writeVarInt(_b, _item.getSerializedSize());
            _item.writeTo(_b);
        }
        return _b.writerIndex() - _writeIdx;
    }

    public int getSerializedSize() {
        if (this._cachedSize > -1) {
            return this._cachedSize;
        }
        int _size = 0;
        _size += _REQUEST_ID_TAG_SIZE;
        _size += LightProtoCodec.computeVarInt64Size(this.requestId);
        if (this.hasTxnidLeastBits()) {
            _size += _TXNID_LEAST_BITS_TAG_SIZE;
            _size += LightProtoCodec.computeVarInt64Size(this.txnidLeastBits);
        }
        if (this.hasTxnidMostBits()) {
            _size += _TXNID_MOST_BITS_TAG_SIZE;
            _size += LightProtoCodec.computeVarInt64Size(this.txnidMostBits);
        }
        for (int i = 0; i < this._subscriptionsCount; ++i) {
            Subscription _item = this.subscriptions.get(i);
            _size += _SUBSCRIPTION_TAG_SIZE;
            int MsgsizeSubscription = _item.getSerializedSize();
            _size += LightProtoCodec.computeVarIntSize(MsgsizeSubscription) + MsgsizeSubscription;
        }
        this._cachedSize = _size;
        return _size;
    }

    public void parseFrom(ByteBuf _buffer, int _size) {
        this.clear();
        int _endIdx = _buffer.readerIndex() + _size;
        block6: while (_buffer.readerIndex() < _endIdx) {
            int _tag = LightProtoCodec.readVarInt(_buffer);
            switch (_tag) {
                case 8: {
                    this._bitField0 |= 1;
                    this.requestId = LightProtoCodec.readVarInt64(_buffer);
                    continue block6;
                }
                case 16: {
                    this._bitField0 |= 2;
                    this.txnidLeastBits = LightProtoCodec.readVarInt64(_buffer);
                    continue block6;
                }
                case 24: {
                    this._bitField0 |= 4;
                    this.txnidMostBits = LightProtoCodec.readVarInt64(_buffer);
                    continue block6;
                }
                case 34: {
                    int _subscriptionSize = LightProtoCodec.readVarInt(_buffer);
                    this.addSubscription().parseFrom(_buffer, _subscriptionSize);
                    continue block6;
                }
            }
            LightProtoCodec.skipUnknownField(_tag, _buffer);
        }
        this.checkRequiredFields();
        this._parsedBuffer = _buffer;
    }

    private void checkRequiredFields() {
        if ((this._bitField0 & 1) != 1) {
            throw new IllegalStateException("Some required fields are missing");
        }
    }

    public CommandAddSubscriptionToTxn clear() {
        this.txnidLeastBits = 0L;
        this.txnidMostBits = 0L;
        for (int i = 0; i < this._subscriptionsCount; ++i) {
            this.subscriptions.get(i).clear();
        }
        this._subscriptionsCount = 0;
        this._parsedBuffer = null;
        this._cachedSize = -1;
        this._bitField0 = 0;
        return this;
    }

    public CommandAddSubscriptionToTxn copyFrom(CommandAddSubscriptionToTxn _other) {
        this._cachedSize = -1;
        if (_other.hasRequestId()) {
            this.setRequestId(_other.requestId);
        }
        if (_other.hasTxnidLeastBits()) {
            this.setTxnidLeastBits(_other.txnidLeastBits);
        }
        if (_other.hasTxnidMostBits()) {
            this.setTxnidMostBits(_other.txnidMostBits);
        }
        for (int i = 0; i < _other.getSubscriptionsCount(); ++i) {
            this.addSubscription().copyFrom(_other.getSubscriptionAt(i));
        }
        return this;
    }

    public byte[] toByteArray() {
        byte[] a = new byte[this.getSerializedSize()];
        ByteBuf b = Unpooled.wrappedBuffer((byte[])a).writerIndex(0);
        this.writeTo(b);
        return a;
    }

    public void parseFrom(byte[] a) {
        ByteBuf b = Unpooled.wrappedBuffer((byte[])a);
        this.parseFrom(b, b.readableBytes());
    }
}

