/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.oxia.client.auth;

import com.google.common.base.Strings;
import io.streamnative.oxia.client.api.Authentication;
import io.streamnative.oxia.client.api.EncodedAuthenticationParameterSupport;
import io.streamnative.oxia.client.api.exceptions.UnsupportedAuthenticationException;
import java.lang.reflect.Constructor;

public class AuthenticationFactory {
    public static Authentication create(String authPluginClassName, String authParamsString) throws UnsupportedAuthenticationException {
        try {
            if (!Strings.isNullOrEmpty((String)authPluginClassName)) {
                Class<?> authClass = Class.forName(authPluginClassName);
                Constructor<?> declaredConstructor = authClass.getDeclaredConstructor(new Class[0]);
                declaredConstructor.setAccessible(true);
                Authentication auth = (Authentication)declaredConstructor.newInstance(new Object[0]);
                if (auth instanceof EncodedAuthenticationParameterSupport) {
                    ((EncodedAuthenticationParameterSupport)auth).configure(authParamsString);
                }
                return auth;
            }
        }
        catch (Throwable t) {
            throw new UnsupportedAuthenticationException("Failed to create authentication", t);
        }
        return null;
    }
}

