/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.grpc.xds.AutoValue_HttpConnectionManager;
import io.grpc.xds.Filter;
import io.grpc.xds.VirtualHost;
import java.util.List;
import javax.annotation.Nullable;

@AutoValue
abstract class HttpConnectionManager {
    HttpConnectionManager() {
    }

    abstract long httpMaxStreamDurationNano();

    @Nullable
    abstract String rdsName();

    @Nullable
    abstract ImmutableList<VirtualHost> virtualHosts();

    @Nullable
    abstract ImmutableList<Filter.NamedFilterConfig> httpFilterConfigs();

    static HttpConnectionManager forRdsName(long httpMaxStreamDurationNano, String rdsName, @Nullable List<Filter.NamedFilterConfig> httpFilterConfigs) {
        Preconditions.checkNotNull((Object)rdsName, (Object)"rdsName");
        return HttpConnectionManager.create(httpMaxStreamDurationNano, rdsName, null, httpFilterConfigs);
    }

    static HttpConnectionManager forVirtualHosts(long httpMaxStreamDurationNano, List<VirtualHost> virtualHosts, @Nullable List<Filter.NamedFilterConfig> httpFilterConfigs) {
        Preconditions.checkNotNull(virtualHosts, (Object)"virtualHosts");
        return HttpConnectionManager.create(httpMaxStreamDurationNano, null, virtualHosts, httpFilterConfigs);
    }

    private static HttpConnectionManager create(long httpMaxStreamDurationNano, @Nullable String rdsName, @Nullable List<VirtualHost> virtualHosts, @Nullable List<Filter.NamedFilterConfig> httpFilterConfigs) {
        return new AutoValue_HttpConnectionManager(httpMaxStreamDurationNano, rdsName, (ImmutableList<VirtualHost>)(virtualHosts == null ? null : ImmutableList.copyOf(virtualHosts)), (ImmutableList<Filter.NamedFilterConfig>)(httpFilterConfigs == null ? null : ImmutableList.copyOf(httpFilterConfigs)));
    }
}

