/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.nar;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.pulsar.common.nar.NarUnpacker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NarClassLoader
extends URLClassLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NarClassLoader.class);
    private static final FileFilter JAR_FILTER = pathname -> {
        String nameToTest = pathname.getName().toLowerCase();
        return nameToTest.endsWith(".jar") && pathname.isFile();
    };
    private final File narWorkingDirectory;
    private final AtomicBoolean closed = new AtomicBoolean();
    private static final String TMP_DIR_PREFIX = "pulsar-nar";
    public static final String DEFAULT_NAR_EXTRACTION_DIR = System.getProperty("nar.extraction.tmpdir") != null ? System.getProperty("nar.extraction.tmpdir") : System.getProperty("java.io.tmpdir");

    static NarClassLoader getFromArchive(File narPath, final Set<String> additionalJars, final ClassLoader parent, String narExtractionDirectory) throws IOException {
        final File unpacked = NarUnpacker.unpackNar(narPath, NarClassLoader.getNarExtractionDirectory(narExtractionDirectory));
        return AccessController.doPrivileged(new PrivilegedAction<NarClassLoader>(){

            @Override
            public NarClassLoader run() {
                return new NarClassLoader(unpacked, additionalJars, parent);
            }
        });
    }

    public static List<File> getClasspathFromArchive(File narPath, String narExtractionDirectory) throws IOException {
        File unpacked = NarUnpacker.unpackNar(narPath, NarClassLoader.getNarExtractionDirectory(narExtractionDirectory));
        return NarClassLoader.getClassPathEntries(unpacked);
    }

    private static File getNarExtractionDirectory(String configuredDirectory) {
        return new File(configuredDirectory + "/" + TMP_DIR_PREFIX);
    }

    private NarClassLoader(File narWorkingDirectory, Set<String> additionalJars, ClassLoader parent) throws IOException {
        super(new URL[0], parent);
        this.narWorkingDirectory = narWorkingDirectory;
        this.updateClasspath(narWorkingDirectory);
        if (additionalJars != null) {
            for (String jar : additionalJars) {
                this.addURL(Paths.get(jar, new String[0]).toUri().toURL());
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Created class loader with paths: {}", (Object)Arrays.toString(this.getURLs()));
        }
    }

    public File getWorkingDirectory() {
        return this.narWorkingDirectory;
    }

    public String getServiceDefinition(String serviceName) throws IOException {
        String serviceDefPath = this.narWorkingDirectory + "/META-INF/services/" + serviceName;
        return new String(Files.readAllBytes(Paths.get(serviceDefPath, new String[0])), StandardCharsets.UTF_8);
    }

    public List<String> getServiceImplementation(String serviceName) throws IOException {
        ArrayList<String> impls = new ArrayList<String>();
        String serviceDefPath = this.narWorkingDirectory + "/META-INF/services/" + serviceName;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(serviceDefPath), StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                int indexOfPound = line.indexOf("#");
                String effectiveLine = indexOfPound > 0 ? line.substring(0, indexOfPound) : line;
                impls.add(effectiveLine);
            }
        }
        return impls;
    }

    private void updateClasspath(File root) throws IOException {
        NarClassLoader.getClassPathEntries(root).forEach(f -> {
            try {
                this.addURL(f.toURI().toURL());
            }
            catch (IOException e) {
                log.error("Failed to add entry to classpath: {}", f, (Object)e);
            }
        });
    }

    static List<File> getClassPathEntries(File root) {
        File[] jarFiles;
        ArrayList<File> classPathEntries = new ArrayList<File>();
        classPathEntries.add(root);
        File dependencies = new File(root, "META-INF/bundled-dependencies");
        if (!dependencies.isDirectory()) {
            log.warn("{} does not contain META-INF/bundled-dependencies!", (Object)root);
        }
        classPathEntries.add(dependencies);
        if (dependencies.isDirectory() && (jarFiles = dependencies.listFiles(JAR_FILTER)) != null) {
            Arrays.sort(jarFiles, Comparator.comparing(File::getName));
            classPathEntries.addAll(Arrays.asList(jarFiles));
        }
        return classPathEntries;
    }

    @Override
    protected String findLibrary(String libname) {
        File dependencies = new File(this.narWorkingDirectory, "META-INF/bundled-dependencies");
        if (!dependencies.isDirectory()) {
            log.warn("{} does not contain META-INF/bundled-dependencies!", (Object)this.narWorkingDirectory);
        }
        File nativeDir = new File(dependencies, "native");
        File libsoFile = new File(nativeDir, "lib" + libname + ".so");
        File dllFile = new File(nativeDir, libname + ".dll");
        File soFile = new File(nativeDir, libname + ".so");
        if (libsoFile.exists()) {
            return libsoFile.getAbsolutePath();
        }
        if (dllFile.exists()) {
            return dllFile.getAbsolutePath();
        }
        if (soFile.exists()) {
            return soFile.getAbsolutePath();
        }
        return null;
    }

    public String toString() {
        return NarClassLoader.class.getName() + "[" + this.narWorkingDirectory.getPath() + "]";
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (this.closed.get()) {
            log.warn("Loading class {} from a closed classloader ({})", (Object)name, (Object)this);
        }
        return super.loadClass(name, resolve);
    }

    @Override
    public void close() throws IOException {
        this.closed.set(true);
        super.close();
    }
}

