/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.compaction;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.pulsar.common.api.proto.BrokerEntryMetadata;
import org.apache.pulsar.common.protocol.Commands;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.compaction.CompactedTopicImpl;
import org.apache.pulsar.compaction.Compactor;
import org.apache.pulsar.compaction.TopicCompactionService;
import org.jspecify.annotations.NonNull;

public class PulsarTopicCompactionService
implements TopicCompactionService {
    private final String topic;
    private final CompactedTopicImpl compactedTopic;
    private final Supplier<Compactor> compactorSupplier;

    public PulsarTopicCompactionService(String topic, BookKeeper bookKeeper, Supplier<Compactor> compactorSupplier) {
        this.topic = topic;
        this.compactedTopic = new CompactedTopicImpl(bookKeeper);
        this.compactorSupplier = compactorSupplier;
    }

    @Override
    public CompletableFuture<Void> compact() {
        Compactor compactor;
        try {
            compactor = this.compactorSupplier.get();
        }
        catch (Throwable e) {
            return CompletableFuture.failedFuture(e);
        }
        return compactor.compact(this.topic).thenApply(x -> null);
    }

    @Override
    public CompletableFuture<List<Entry>> readCompactedEntries(@NonNull Position startPosition, int numberOfEntriesToRead) {
        Objects.requireNonNull(startPosition);
        Preconditions.checkArgument((numberOfEntriesToRead > 0 ? 1 : 0) != 0);
        CompletableFuture<List<Entry>> resultFuture = new CompletableFuture<List<Entry>>();
        ((CompletableFuture)Objects.requireNonNull(this.compactedTopic.getCompactedTopicContextFuture()).thenCompose(context -> CompactedTopicImpl.findStartPoint((PositionImpl)startPosition, context.ledger.getLastAddConfirmed(), context.cache).thenCompose(startPoint -> {
            if (startPoint == -4276948923L || startPoint == -4276948922L) {
                return CompletableFuture.completedFuture(Collections.emptyList());
            }
            long endPoint = Math.min(context.ledger.getLastAddConfirmed(), startPoint + (long)(numberOfEntriesToRead - 1));
            return CompactedTopicImpl.readEntries(context.ledger, startPoint, endPoint);
        }))).whenComplete((result, ex) -> {
            if (ex == null) {
                resultFuture.complete((List<Entry>)result);
            } else if ((ex = FutureUtil.unwrapCompletionException((Throwable)ex)) instanceof NoSuchElementException) {
                resultFuture.complete(Collections.emptyList());
            } else {
                resultFuture.completeExceptionally((Throwable)ex);
            }
        });
        return resultFuture;
    }

    @Override
    public CompletableFuture<Entry> readLastCompactedEntry() {
        return this.compactedTopic.readLastEntryOfCompactedLedger();
    }

    @Override
    public CompletableFuture<Position> getLastCompactedPosition() {
        return CompletableFuture.completedFuture(this.compactedTopic.getCompactionHorizon().orElse(null));
    }

    @Override
    public CompletableFuture<Entry> findEntryByPublishTime(long publishTime) {
        Predicate<Entry> predicate = entry -> Commands.parseMessageMetadata((ByteBuf)entry.getDataBuffer()).getPublishTime() >= publishTime;
        return this.compactedTopic.findFirstMatchEntry(predicate);
    }

    @Override
    public CompletableFuture<Entry> findEntryByEntryIndex(long entryIndex) {
        Predicate<Entry> predicate = entry -> {
            BrokerEntryMetadata brokerEntryMetadata = Commands.parseBrokerEntryMetadataIfExist((ByteBuf)entry.getDataBuffer());
            if (brokerEntryMetadata == null || !brokerEntryMetadata.hasIndex()) {
                return false;
            }
            return brokerEntryMetadata.getIndex() >= entryIndex;
        };
        return this.compactedTopic.findFirstMatchEntry(predicate);
    }

    public CompactedTopicImpl getCompactedTopic() {
        return this.compactedTopic;
    }

    @Override
    public void close() throws IOException {
    }
}

