/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.sockjs.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.shareddata.LocalMap;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.sockjs.SockJSHandlerOptions;
import io.vertx.ext.web.handler.sockjs.SockJSSocket;
import io.vertx.ext.web.handler.sockjs.impl.BaseTransport;
import io.vertx.ext.web.handler.sockjs.impl.SockJSSession;
import java.util.regex.Pattern;

class HtmlFileTransport
extends BaseTransport {
    private static final Logger LOG = LoggerFactory.getLogger(HtmlFileTransport.class);
    private static final Pattern CALLBACK_VALIDATION = Pattern.compile("[^a-zA-Z0-9-_.]");
    private static final String HTML_FILE_TEMPLATE;
    private final Handler<SockJSSocket> sockHandler;

    HtmlFileTransport(Vertx vertx, Router router, LocalMap<String, SockJSSession> sessions, SockJSHandlerOptions options, Handler<SockJSSocket> sockHandler) {
        super(vertx, sessions, options);
        this.sockHandler = sockHandler;
        String htmlFileRE = "\\/[^\\/\\.]+\\/([^\\/\\.]+)\\/htmlfile.*";
        router.getWithRegex(htmlFileRE).handler(this::handleGet);
    }

    private void handleGet(RoutingContext ctx) {
        String callback = ctx.request().getParam("callback");
        if (callback == null && (callback = ctx.request().getParam("c")) == null) {
            ctx.response().setStatusCode(500).end("\"callback\" parameter required\n");
            return;
        }
        if (CALLBACK_VALIDATION.matcher(callback).find()) {
            ctx.response().setStatusCode(500);
            ctx.response().end("invalid \"callback\" parameter\n");
            return;
        }
        HttpServerRequest req = ctx.request();
        String sessionID = req.params().get("param0");
        SockJSSession session = this.getSession(ctx, this.options, sessionID, this.sockHandler);
        session.register(req, new HtmlFileListener(this.options.getMaxBytesStreaming(), ctx, callback, session));
    }

    static {
        String str = "<!doctype html>\n<html><head>\n  <meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\" />\n  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />\n</head><body><h2>Don't panic!</h2>\n  <script>\n    document.domain = document.domain;\n    var c = parent.{{ callback }};\n    c.start();\n    function p(d) {c.message(d);};\n    window.onload = function() {c.stop();};\n  </script>";
        String str2 = str.replace("{{ callback }}", "");
        StringBuilder sb = new StringBuilder(str);
        int extra = 1024 - str2.length();
        for (int i = 0; i < extra; ++i) {
            sb.append(' ');
        }
        sb.append("\r\n");
        HTML_FILE_TEMPLATE = sb.toString();
    }

    private class HtmlFileListener
    extends BaseTransport.BaseListener {
        final int maxBytesStreaming;
        final String callback;
        boolean headersWritten;
        int bytesSent;

        HtmlFileListener(int maxBytesStreaming, RoutingContext rc, String callback, SockJSSession session) {
            super(rc, session);
            this.maxBytesStreaming = maxBytesStreaming;
            this.callback = callback;
            this.addCloseHandler(rc.response(), session);
        }

        @Override
        public void sendFrame(String body, Handler<AsyncResult<Void>> handler) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"HtmlFile, sending frame");
            }
            if (!this.headersWritten) {
                String htmlFile = HTML_FILE_TEMPLATE.replace("{{ callback }}", this.callback);
                this.rc.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/html; charset=UTF-8");
                BaseTransport.setNoCacheHeaders(this.rc);
                this.rc.response().setChunked(true);
                BaseTransport.setJSESSIONID(HtmlFileTransport.this.options, this.rc);
                this.rc.response().write(htmlFile);
                this.headersWritten = true;
            }
            body = HtmlFileTransport.this.escapeForJavaScript(body);
            String sb = "<script>\np(\"" + body + "\");\n</script>\r\n";
            Buffer buff = Buffer.buffer((String)sb);
            this.rc.response().write((Object)buff, handler);
            this.bytesSent += buff.length();
            if (this.bytesSent >= this.maxBytesStreaming) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)"More than maxBytes sent so closing connection");
                }
                this.close();
            }
        }

        @Override
        public void close() {
            if (!this.closed) {
                try {
                    this.session.resetListener();
                    this.rc.response().end();
                    this.rc.response().close();
                    this.closed = true;
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
    }
}

