/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.oxia.client.api;

import io.streamnative.oxia.client.api.Version;
import lombok.NonNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Notification {
    public String key();

    public record KeyRangeDelete(@NonNull String startKeyInclusive, @NonNull String endKeyExclusive) implements Notification
    {
        public KeyRangeDelete(@NonNull String startKeyInclusive, @NonNull String endKeyExclusive) {
            if (startKeyInclusive == null) {
                throw new NullPointerException("startKeyInclusive is marked non-null but is null");
            }
            if (endKeyExclusive == null) {
                throw new NullPointerException("endKeyExclusive is marked non-null but is null");
            }
        }

        @Override
        public String key() {
            return this.startKeyInclusive;
        }
    }

    public record KeyDeleted(@NonNull String key) implements Notification
    {
        public KeyDeleted(@NonNull String key) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
        }
    }

    public record KeyModified(@NonNull String key, long version) implements Notification
    {
        public KeyModified(@NonNull String key, long version) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            Version.requireValidVersionId(version);
        }
    }

    public record KeyCreated(@NonNull String key, long version) implements Notification
    {
        public KeyCreated(@NonNull String key, long version) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            Version.requireValidVersionId(version);
        }
    }
}

