/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.org.roaringbitmap.buffer;

import org.apache.pig.org.roaringbitmap.IntIterator;
import org.apache.pig.org.roaringbitmap.ShortIterator;
import org.apache.pig.org.roaringbitmap.buffer.BufferUtil;
import org.apache.pig.org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.apache.pig.org.roaringbitmap.buffer.MappeableArrayContainer;
import org.apache.pig.org.roaringbitmap.buffer.MappeableBitmapContainer;
import org.apache.pig.org.roaringbitmap.buffer.MappeableContainer;
import org.apache.pig.org.roaringbitmap.buffer.MappeableRunContainer;
import org.apache.pig.org.roaringbitmap.buffer.ReverseMappeableArrayContainerShortIterator;
import org.apache.pig.org.roaringbitmap.buffer.ReverseMappeableBitmapContainerShortIterator;
import org.apache.pig.org.roaringbitmap.buffer.ReverseMappeableRunContainerShortIterator;

public class BufferReverseIntIteratorFlyweight
implements IntIterator {
    private int hs;
    private ShortIterator iter;
    private ReverseMappeableArrayContainerShortIterator arrIter = new ReverseMappeableArrayContainerShortIterator();
    private ReverseMappeableBitmapContainerShortIterator bitmapIter = new ReverseMappeableBitmapContainerShortIterator();
    private ReverseMappeableRunContainerShortIterator runIter = new ReverseMappeableRunContainerShortIterator();
    private short pos;
    private ImmutableRoaringBitmap roaringBitmap = null;

    public BufferReverseIntIteratorFlyweight() {
    }

    public BufferReverseIntIteratorFlyweight(ImmutableRoaringBitmap r) {
        this.wrap(r);
    }

    @Override
    public IntIterator clone() {
        try {
            BufferReverseIntIteratorFlyweight x = (BufferReverseIntIteratorFlyweight)super.clone();
            if (this.iter != null) {
                x.iter = this.iter.clone();
            }
            return x;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.pos >= 0;
    }

    @Override
    public int next() {
        int x = this.iter.nextAsInt() | this.hs;
        if (!this.iter.hasNext()) {
            this.pos = (short)(this.pos - 1);
            this.nextContainer();
        }
        return x;
    }

    private void nextContainer() {
        if (this.pos >= 0) {
            MappeableContainer container = this.roaringBitmap.highLowContainer.getContainerAtIndex(this.pos);
            if (container instanceof MappeableBitmapContainer) {
                this.bitmapIter.wrap((MappeableBitmapContainer)container);
                this.iter = this.bitmapIter;
            } else if (container instanceof MappeableRunContainer) {
                this.runIter.wrap((MappeableRunContainer)container);
                this.iter = this.runIter;
            } else {
                this.arrIter.wrap((MappeableArrayContainer)container);
                this.iter = this.arrIter;
            }
            this.hs = BufferUtil.toIntUnsigned(this.roaringBitmap.highLowContainer.getKeyAtIndex(this.pos)) << 16;
        }
    }

    public void wrap(ImmutableRoaringBitmap r) {
        this.roaringBitmap = r;
        this.hs = 0;
        this.pos = (short)(this.roaringBitmap.highLowContainer.size() - 1);
        this.nextContainer();
    }
}

