/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.evaluation.decode;

import java.io.IOException;
import org.apache.pig.EvalFunc;
import org.apache.pig.PigWarning;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class Decode
extends EvalFunc<String> {
    int numParams = -1;

    public Schema outputSchema(Schema input) {
        try {
            return new Schema(new Schema.FieldSchema(this.getSchemaName(((Object)((Object)this)).getClass().getName().toLowerCase(), input), 55));
        }
        catch (Exception e) {
            return null;
        }
    }

    public String exec(Tuple tuple) throws IOException {
        if (this.numParams == -1) {
            this.numParams = tuple.size();
            if (this.numParams <= 2) {
                String msg = "Decode: Atleast an expression and default string is required.";
                throw new IOException(msg);
            }
            if (tuple.size() % 2 != 0) {
                String msg = "Decode : Some parameters are unmatched.";
                throw new IOException(msg);
            }
        }
        if (tuple.get(0) == null) {
            return null;
        }
        try {
            for (int count = 1; count < this.numParams - 1; count += 2) {
                if (!tuple.get(count).equals(tuple.get(0))) continue;
                return (String)tuple.get(count + 1);
            }
        }
        catch (ClassCastException e) {
            this.warn("Decode : Data type error", (Enum)PigWarning.UDF_WARNING_1);
            return null;
        }
        catch (NullPointerException e) {
            String msg = "Decode : Encounter null in the input";
            throw new IOException(msg);
        }
        return (String)tuple.get(tuple.size() - 1);
    }
}

