/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.tokenize;

import opennlp.tools.tokenize.TokenSample;
import opennlp.tools.tokenize.Tokenizer;
import opennlp.tools.tokenize.TokenizerEvaluationMonitor;
import opennlp.tools.util.Span;
import opennlp.tools.util.eval.Evaluator;
import opennlp.tools.util.eval.FMeasure;

public class TokenizerEvaluator
extends Evaluator<TokenSample> {
    private final FMeasure fmeasure = new FMeasure();
    private final Tokenizer tokenizer;

    public TokenizerEvaluator(Tokenizer tokenizer, TokenizerEvaluationMonitor ... listeners) {
        super(listeners);
        this.tokenizer = tokenizer;
    }

    @Override
    protected TokenSample processSample(TokenSample reference) {
        Object[] predictions = this.tokenizer.tokenizePos(reference.getText());
        this.fmeasure.updateScores(reference.getTokenSpans(), predictions);
        return new TokenSample(reference.getText(), (Span[])predictions);
    }

    public FMeasure getFMeasure() {
        return this.fmeasure;
    }
}

