/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.model;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.StringTokenizer;
import opennlp.tools.ml.model.Event;
import opennlp.tools.util.ObjectStream;

public class FileEventStream
implements ObjectStream<Event> {
    private static final String LINE_SEPARATOR = System.lineSeparator();
    protected final BufferedReader reader;

    public FileEventStream(String fileName, String encoding) throws IOException {
        this(encoding == null ? new FileReader(fileName) : new InputStreamReader((InputStream)new FileInputStream(fileName), encoding));
    }

    public FileEventStream(String fileName) throws IOException {
        this(fileName, null);
    }

    public FileEventStream(Reader reader) throws IOException {
        this.reader = new BufferedReader(reader);
    }

    public FileEventStream(File file) throws IOException {
        this.reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
    }

    @Override
    public Event read() throws IOException {
        String line = this.reader.readLine();
        if (line != null) {
            StringTokenizer st = new StringTokenizer(line);
            String outcome = st.nextToken();
            int count = st.countTokens();
            CharSequence[] context = new String[count];
            for (int ci = 0; ci < count; ++ci) {
                context[ci] = st.nextToken();
            }
            return new Event(outcome, context);
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public static String toLine(Event event) {
        String[] context;
        StringBuilder sb = new StringBuilder();
        sb.append(event.getOutcome());
        for (String s : context = event.getContext()) {
            sb.append(" ").append(s);
        }
        sb.append(LINE_SEPARATOR);
        return sb.toString();
    }

    @Override
    public void reset() throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

