/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.langdetect;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import opennlp.tools.cmdline.AbstractCrossValidatorTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.langdetect.LanguageDetectorEvaluationErrorListener;
import opennlp.tools.cmdline.langdetect.LanguageDetectorFineGrainedReportListener;
import opennlp.tools.cmdline.langdetect.TrainingParams;
import opennlp.tools.cmdline.params.CVParams;
import opennlp.tools.cmdline.params.FineGrainedEvaluatorParams;
import opennlp.tools.langdetect.LanguageDetectorCrossValidator;
import opennlp.tools.langdetect.LanguageDetectorEvaluationMonitor;
import opennlp.tools.langdetect.LanguageDetectorFactory;
import opennlp.tools.langdetect.LanguageSample;
import opennlp.tools.util.model.ModelUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LanguageDetectorCrossValidatorTool
extends AbstractCrossValidatorTool<LanguageSample, CVToolParams> {
    private static final Logger logger = LoggerFactory.getLogger(LanguageDetectorCrossValidatorTool.class);

    public LanguageDetectorCrossValidatorTool() {
        super(LanguageSample.class, CVToolParams.class);
    }

    @Override
    public String getShortDescription() {
        return "K-fold cross validator for the learnable Language Detector";
    }

    @Override
    public void run(String format, String[] args) {
        LanguageDetectorCrossValidator validator;
        super.run(format, args);
        this.mlParams = CmdLineUtil.loadTrainingParameters(((CVToolParams)this.params).getParams(), false);
        if (this.mlParams == null) {
            this.mlParams = ModelUtil.createDefaultTrainingParameters();
        }
        LinkedList<LanguageDetectorEvaluationMonitor> listeners = new LinkedList<LanguageDetectorEvaluationMonitor>();
        if (((CVToolParams)this.params).getMisclassified().booleanValue()) {
            listeners.add(new LanguageDetectorEvaluationErrorListener());
        }
        LanguageDetectorFineGrainedReportListener reportListener = null;
        File reportFile = ((CVToolParams)this.params).getReportOutputFile();
        FileOutputStream reportOutputStream = null;
        if (reportFile != null) {
            CmdLineUtil.checkOutputFile("Report Output File", reportFile);
            try {
                reportOutputStream = new FileOutputStream(reportFile);
                reportListener = new LanguageDetectorFineGrainedReportListener(reportOutputStream);
                listeners.add(reportListener);
            }
            catch (FileNotFoundException e) {
                throw this.createTerminationIOException(e);
            }
        }
        LanguageDetectorEvaluationMonitor[] listenersArr = listeners.toArray(new LanguageDetectorEvaluationMonitor[0]);
        try {
            LanguageDetectorFactory factory = LanguageDetectorFactory.create(((CVToolParams)this.params).getFactory());
            validator = new LanguageDetectorCrossValidator(this.mlParams, factory, listenersArr);
            validator.evaluate(this.sampleStream, ((CVToolParams)this.params).getFolds());
        }
        catch (IOException e) {
            throw new TerminateToolException(-1, "IO error while reading training data or indexing data: " + e.getMessage(), e);
        }
        finally {
            try {
                this.sampleStream.close();
            }
            catch (IOException iOException) {}
        }
        logger.info("done");
        if (reportListener != null) {
            logger.info("Writing fine-grained report to {}", (Object)((CVToolParams)this.params).getReportOutputFile().getAbsolutePath());
            reportListener.writeReport();
            try {
                reportOutputStream.flush();
                ((OutputStream)reportOutputStream).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        logger.info("Accuracy: {} Number of documents: {}", (Object)validator.getDocumentAccuracy(), (Object)validator.getDocumentCount());
    }

    static interface CVToolParams
    extends CVParams,
    TrainingParams,
    FineGrainedEvaluatorParams {
    }
}

