/*
 * Decompiled with CFR 0.152.
 */
package opennlp.uima.normalizer;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.regex.Pattern;

public final class NumberUtil {
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s");

    public static boolean isLanguageSupported(String languageCode) {
        Locale locale = new Locale(languageCode);
        Locale[] possibleLocales = NumberFormat.getAvailableLocales();
        boolean isLocaleSupported = false;
        for (Locale possibleLocale : possibleLocales) {
            if (!possibleLocale.equals(locale)) continue;
            isLocaleSupported = true;
            break;
        }
        return isLocaleSupported;
    }

    public static Number parse(String number, String languageCode) throws ParseException {
        if (!NumberUtil.isLanguageSupported(languageCode)) {
            throw new IllegalArgumentException("Language " + languageCode + " is not supported!");
        }
        Locale locale = new Locale(languageCode);
        NumberFormat numberFormat = NumberFormat.getInstance(locale);
        number = WHITESPACE_PATTERN.matcher(number).replaceAll("");
        return numberFormat.parse(number);
    }
}

