/*
 * Decompiled with CFR 0.152.
 */
package opennlp.uima.doccat;

import java.util.ArrayList;
import opennlp.tools.doccat.DoccatModel;
import opennlp.tools.doccat.DocumentCategorizer;
import opennlp.tools.doccat.DocumentCategorizerME;
import opennlp.uima.doccat.DoccatModelResource;
import opennlp.uima.util.AnnotatorUtil;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.CasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.resource.ResourceAccessException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

abstract class AbstractDocumentCategorizer
extends CasAnnotator_ImplBase {
    private UimaContext context;
    private DocumentCategorizer mCategorizer;
    private Type mTokenType;

    AbstractDocumentCategorizer() {
    }

    public void initialize(UimaContext context) throws ResourceInitializationException {
        DoccatModel model;
        super.initialize(context);
        this.context = context;
        Logger mLogger = context.getLogger();
        if (mLogger.isLoggable(Level.DEBUG)) {
            mLogger.log(Level.DEBUG, "Initializing the OpenNLP Categorizer.");
        }
        try {
            DoccatModelResource modelResource = (DoccatModelResource)context.getResourceObject("opennlp.uima.ModelName");
            model = modelResource.getModel();
        }
        catch (ResourceAccessException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
        this.mCategorizer = new DocumentCategorizerME(model);
    }

    public void typeSystemInit(TypeSystem typeSystem) throws AnalysisEngineProcessException {
        this.mTokenType = AnnotatorUtil.getRequiredTypeParameter(this.context, typeSystem, "opennlp.uima.TokenType");
    }

    protected abstract void setBestCategory(CAS var1, String var2);

    public void process(CAS cas) {
        FSIterator tokenAnnotations = cas.getAnnotationIndex(this.mTokenType).iterator();
        ArrayList<String> tokensList = new ArrayList<String>();
        while (tokenAnnotations.hasNext()) {
            tokensList.add(((AnnotationFS)tokenAnnotations.next()).getCoveredText());
        }
        double[] result = this.mCategorizer.categorize(tokensList.toArray(new String[0]));
        String bestCategory = this.mCategorizer.getBestCategory(result);
        this.setBestCategory(cas, bestCategory);
    }
}

