/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.signing.ssh;

import java.security.Key;
import java.security.PublicKey;
import java.text.MessageFormat;
import java.time.Instant;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.OpenSshCertificate;
import org.apache.sshd.common.signature.BuiltinSignatures;
import org.apache.sshd.common.signature.Signature;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.internal.transport.sshd.SshdText;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SshCertificateUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SshCertificateUtils.class);

    SshCertificateUtils() {
    }

    static String verify(OpenSshCertificate certificate, Instant signatureTime) {
        if (!OpenSshCertificate.Type.USER.equals((Object)certificate.getType())) {
            return MessageFormat.format(SshdText.get().signNotUserCertificate, KeyUtils.getFingerPrint((PublicKey)certificate.getCaPubKey()));
        }
        String message = SshCertificateUtils.verifySignature(certificate);
        if (message == null && signatureTime != null) {
            message = SshCertificateUtils.checkExpiration(certificate, signatureTime);
        }
        return message;
    }

    static String verifySignature(OpenSshCertificate certificate) {
        PublicKey caKey = certificate.getCaPubKey();
        PublicKey certifiedKey = certificate.getCertPubKey();
        if (caKey == null || caKey instanceof OpenSshCertificate || certifiedKey == null || certifiedKey instanceof OpenSshCertificate) {
            return SshdText.get().signCertificateInvalid;
        }
        String keyType = KeyUtils.getKeyType((Key)caKey);
        String certAlgorithm = certificate.getSignatureAlgorithm();
        if (!KeyUtils.getCanonicalKeyType((String)keyType).equals(KeyUtils.getCanonicalKeyType((String)certAlgorithm))) {
            return MessageFormat.format(SshdText.get().signCertAlgorithmMismatch, keyType, KeyUtils.getFingerPrint((PublicKey)certificate.getCaPubKey()), certAlgorithm);
        }
        BuiltinSignatures factory = BuiltinSignatures.fromFactoryName((String)certAlgorithm);
        if (factory == null || !factory.isSupported()) {
            return MessageFormat.format(SshdText.get().signCertAlgorithmUnknown, KeyUtils.getFingerPrint((PublicKey)certificate.getCaPubKey()), certAlgorithm);
        }
        Signature signer = (Signature)factory.create();
        try {
            signer.initVerifier(null, caKey);
            signer.update(null, certificate.getMessage());
            if (signer.verify(null, certificate.getRawSignature())) {
                return null;
            }
        }
        catch (Exception e) {
            LOG.warn("{}", (Object)SshdText.get().signLogFailure, (Object)e);
            return SshdText.get().signSeeLog;
        }
        return MessageFormat.format(SshdText.get().signCertificateInvalid, KeyUtils.getFingerPrint((PublicKey)certificate.getCaPubKey()));
    }

    static String checkExpiration(OpenSshCertificate certificate, @NonNull Instant signatureTime) {
        long instant = signatureTime.getEpochSecond();
        if (Long.compareUnsigned(instant, certificate.getValidAfter()) < 0) {
            return MessageFormat.format(SshdText.get().signCertificateTooEarly, KeyUtils.getFingerPrint((PublicKey)certificate.getCaPubKey()));
        }
        if (Long.compareUnsigned(instant, certificate.getValidBefore()) > 0) {
            return MessageFormat.format(SshdText.get().signCertificateExpired, KeyUtils.getFingerPrint((PublicKey)certificate.getCaPubKey()));
        }
        return null;
    }
}

