/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.cert;

import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Objects;
import javax.security.auth.x500.X500Principal;
import org.apache.nifi.security.cert.PrincipalFormatter;

public class StandardPrincipalFormatter
implements PrincipalFormatter {
    private static final PrincipalFormatter INSTANCE = new StandardPrincipalFormatter();
    private static final Map<String, String> OBJECT_IDENTIFIER_NAMES = Map.of("0.9.2342.19200300.100.1.1", "UID", "0.9.2342.19200300.100.1.25", "DC");

    private StandardPrincipalFormatter() {
    }

    public static PrincipalFormatter getInstance() {
        return INSTANCE;
    }

    @Override
    public String getSubject(X509Certificate certificate) {
        Objects.requireNonNull(certificate, "Certificate required");
        return this.getFormatted(certificate.getSubjectX500Principal());
    }

    @Override
    public String getIssuer(X509Certificate certificate) {
        Objects.requireNonNull(certificate, "Certificate required");
        return this.getFormatted(certificate.getIssuerX500Principal());
    }

    private String getFormatted(X500Principal principal) {
        return principal.getName("RFC1779", OBJECT_IDENTIFIER_NAMES);
    }
}

