/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web;

import java.util.Collection;
import java.util.Map;
import org.apache.nifi.web.ComponentDescriptor;
import org.apache.nifi.web.Revision;

public class ComponentDetails {
    private final String id;
    private final Revision revision;
    private final String name;
    private final String type;
    private final String state;
    private final String annotationData;
    private final Map<String, String> properties;
    private final Map<String, ComponentDescriptor> descriptors;
    private final Collection<String> validationErrors;

    private ComponentDetails(Builder builder) {
        this.id = builder.id;
        this.revision = builder.revision;
        this.name = builder.name;
        this.type = builder.type;
        this.state = builder.state;
        this.annotationData = builder.annotationData;
        this.properties = builder.properties;
        this.descriptors = builder.descriptors;
        this.validationErrors = builder.validationErrors;
    }

    public String getId() {
        return this.id;
    }

    public Revision getRevision() {
        return this.revision;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getState() {
        return this.state;
    }

    public String getAnnotationData() {
        return this.annotationData;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Map<String, ComponentDescriptor> getDescriptors() {
        return this.descriptors;
    }

    public Collection<String> getValidationErrors() {
        return this.validationErrors;
    }

    public static final class Builder {
        private String id;
        private Revision revision;
        private String name;
        private String type;
        private String state;
        private String annotationData;
        private Map<String, String> properties;
        private Map<String, ComponentDescriptor> descriptors;
        private Collection<String> validationErrors;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder revision(Revision revision) {
            this.revision = revision;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            return this;
        }

        public Builder annotationData(String annotationData) {
            this.annotationData = annotationData;
            return this;
        }

        public Builder properties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        public Builder validateErrors(Collection<String> validationErrors) {
            this.validationErrors = validationErrors;
            return this;
        }

        public Builder descriptors(Map<String, ComponentDescriptor> descriptors) {
            this.descriptors = descriptors;
            return this;
        }

        public ComponentDetails build() {
            return new ComponentDetails(this);
        }
    }
}

