/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.client.impl;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.registry.client.NiFiRegistryException;
import org.apache.nifi.registry.client.RequestConfig;
import org.apache.nifi.registry.revision.entity.RevisionInfo;

public class AbstractJerseyClient {
    private static final RequestConfig EMPTY_REQUEST_CONFIG = () -> Collections.emptyMap();
    private final RequestConfig requestConfig;

    public AbstractJerseyClient(RequestConfig requestConfig) {
        this.requestConfig = requestConfig == null ? EMPTY_REQUEST_CONFIG : requestConfig;
    }

    protected RequestConfig getRequestConfig() {
        return this.requestConfig;
    }

    protected WebTarget addRevisionQueryParams(WebTarget target, RevisionInfo revision) {
        String clientId;
        if (revision == null) {
            return target;
        }
        WebTarget localTarget = target;
        Long version = revision.getVersion();
        if (version != null) {
            localTarget = localTarget.queryParam("version", new Object[]{(long)version});
        }
        if (!StringUtils.isBlank((CharSequence)(clientId = revision.getClientId()))) {
            localTarget = localTarget.queryParam("clientId", new Object[]{clientId});
        }
        return localTarget;
    }

    protected Invocation.Builder getRequestBuilder(WebTarget webTarget) {
        Invocation.Builder requestBuilder = webTarget.request();
        Map<String, String> headers = this.requestConfig.getHeaders();
        headers.entrySet().stream().forEach(e -> requestBuilder.header((String)e.getKey(), e.getValue()));
        return requestBuilder;
    }

    protected <T> T executeAction(String errorMessage, NiFiRegistryAction<T> action) throws NiFiRegistryException, IOException {
        try {
            return action.execute();
        }
        catch (Exception e) {
            Throwable ioeCause = this.getIOExceptionCause(e);
            if (ioeCause == null) {
                StringBuilder errorMessageBuilder = new StringBuilder(errorMessage);
                if (e instanceof WebApplicationException) {
                    Response response = ((WebApplicationException)e).getResponse();
                    String responseBody = (String)response.readEntity(String.class);
                    errorMessageBuilder.append(": ").append(responseBody);
                }
                throw new NiFiRegistryException(errorMessageBuilder.toString(), e);
            }
            throw (IOException)ioeCause;
        }
    }

    protected Throwable getIOExceptionCause(Throwable e) {
        if (e == null) {
            return null;
        }
        if (e instanceof IOException) {
            return e;
        }
        return this.getIOExceptionCause(e.getCause());
    }

    protected static interface NiFiRegistryAction<T> {
        public T execute();
    }
}

