/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.registry.policy;

import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.registry.authorization.AccessPolicy;
import org.apache.nifi.registry.authorization.Tenant;
import org.apache.nifi.registry.client.NiFiRegistryClient;
import org.apache.nifi.registry.client.NiFiRegistryException;
import org.apache.nifi.registry.client.PoliciesClient;
import org.apache.nifi.registry.client.TenantsClient;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.registry.AbstractNiFiRegistryCommand;
import org.apache.nifi.toolkit.cli.impl.command.registry.tenant.TenantHelper;
import org.apache.nifi.toolkit.cli.impl.result.VoidResult;

public class CreateOrUpdateAccessPolicy
extends AbstractNiFiRegistryCommand<VoidResult> {
    public CreateOrUpdateAccessPolicy() {
        super("update-policy", VoidResult.class);
    }

    @Override
    public String getDescription() {
        return "Updates the access policy for the given resource and action, or creates the policy if it doesn't exist. In stand-alone mode this command will not produce all of the output seen in interactive mode unless the --verbose argument is specified.";
    }

    @Override
    protected void doInitialize(Context context) {
        this.addOption(CommandOption.POLICY_RESOURCE.createOption());
        this.addOption(CommandOption.POLICY_ACTION.createOption());
        this.addOption(CommandOption.USER_NAME_LIST.createOption());
        this.addOption(CommandOption.USER_ID_LIST.createOption());
        this.addOption(CommandOption.GROUP_NAME_LIST.createOption());
        this.addOption(CommandOption.GROUP_ID_LIST.createOption());
        this.addOption(CommandOption.OVERWRITE_POLICY.createOption());
    }

    @Override
    public VoidResult doExecute(NiFiRegistryClient client, Properties properties) throws IOException, NiFiRegistryException, ParseException {
        AccessPolicy currentPolicy;
        PoliciesClient policiesClient = client.getPoliciesClient();
        TenantsClient tenantsClient = client.getTenantsClient();
        String action = this.getRequiredArg(properties, CommandOption.POLICY_ACTION);
        String resource = this.getRequiredArg(properties, CommandOption.POLICY_RESOURCE);
        try {
            currentPolicy = policiesClient.getAccessPolicy(action, resource);
        }
        catch (NiFiRegistryException e) {
            currentPolicy = null;
        }
        if (currentPolicy == null) {
            currentPolicy = new AccessPolicy();
            currentPolicy.setAction(action);
            currentPolicy.setResource(resource);
            this.setUsers(currentPolicy, properties, tenantsClient);
            this.setGroups(currentPolicy, properties, tenantsClient);
            policiesClient.createAccessPolicy(currentPolicy);
        } else {
            this.setUsers(currentPolicy, properties, tenantsClient);
            this.setGroups(currentPolicy, properties, tenantsClient);
            policiesClient.updateAccessPolicy(currentPolicy);
        }
        return VoidResult.getInstance();
    }

    private void setUsers(AccessPolicy accessPolicy, Properties properties, TenantsClient tenantsClient) throws IOException, NiFiRegistryException {
        String userNames = this.getArg(properties, CommandOption.USER_NAME_LIST);
        String userIds = this.getArg(properties, CommandOption.USER_ID_LIST);
        if (StringUtils.isNotBlank((CharSequence)userNames) || StringUtils.isNotBlank((CharSequence)userIds)) {
            Set<Tenant> existingUsers = TenantHelper.selectExistingTenants(userNames, userIds, tenantsClient.getUsers());
            accessPolicy.setUsers(existingUsers);
        }
    }

    private void setGroups(AccessPolicy accessPolicy, Properties properties, TenantsClient tenantsClient) throws IOException, NiFiRegistryException {
        String groupNames = this.getArg(properties, CommandOption.GROUP_NAME_LIST);
        String groupIds = this.getArg(properties, CommandOption.GROUP_ID_LIST);
        if (StringUtils.isNotBlank((CharSequence)groupNames) || StringUtils.isNotBlank((CharSequence)groupIds)) {
            Set<Tenant> existingGroups = TenantHelper.selectExistingTenants(groupNames, groupIds, tenantsClient.getUserGroups());
            accessPolicy.setUserGroups(existingGroups);
        }
    }
}

