/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.registry.extension;

import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.ParseException;
import org.apache.nifi.registry.client.ExtensionRepoClient;
import org.apache.nifi.registry.client.NiFiRegistryClient;
import org.apache.nifi.registry.client.NiFiRegistryException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.registry.AbstractNiFiRegistryCommand;
import org.apache.nifi.toolkit.cli.impl.result.registry.ExtensionRepoArtifactsResult;

public class ListBundleArtifacts
extends AbstractNiFiRegistryCommand<ExtensionRepoArtifactsResult> {
    public ListBundleArtifacts() {
        super("list-bundle-artifacts", ExtensionRepoArtifactsResult.class);
    }

    @Override
    protected void doInitialize(Context context) {
        this.addOption(CommandOption.BUCKET_NAME.createOption());
        this.addOption(CommandOption.EXT_BUNDLE_GROUP.createOption());
    }

    @Override
    public String getDescription() {
        return "List the bundle artifacts in the given bucket and group.";
    }

    @Override
    public ExtensionRepoArtifactsResult doExecute(NiFiRegistryClient client, Properties properties) throws IOException, NiFiRegistryException, ParseException {
        String bucketName = this.getRequiredArg(properties, CommandOption.BUCKET_NAME);
        String groupId = this.getRequiredArg(properties, CommandOption.EXT_BUNDLE_GROUP);
        ExtensionRepoClient extensionRepoClient = client.getExtensionRepoClient();
        List artifacts = extensionRepoClient.getArtifacts(bucketName, groupId);
        return new ExtensionRepoArtifactsResult(this.getResultType(properties), artifacts);
    }
}

