/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.json;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.springframework.boot.json.JsonValueWriter;
import org.springframework.boot.json.JsonWriterFiltersAndProcessors;
import org.springframework.boot.json.WritableJson;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@FunctionalInterface
public interface JsonWriter<T> {
    public void write(T var1, Appendable var2) throws IOException;

    default public String writeToString(T instance) {
        return this.write(instance).toJsonString();
    }

    default public WritableJson write(T instance) {
        return WritableJson.of((Appendable out) -> this.write(instance, out));
    }

    default public JsonWriter<T> withNewLineAtEnd() {
        return this.withSuffix("\n");
    }

    default public JsonWriter<T> withSuffix(String suffix) {
        if (!StringUtils.hasLength((String)suffix)) {
            return this;
        }
        return (instance, out) -> {
            this.write(instance, out);
            out.append(suffix);
        };
    }

    public static <T> JsonWriter<T> standard() {
        return JsonWriter.of(Members::add);
    }

    public static <T> JsonWriter<T> of(Consumer<Members<T>> members) {
        Members initializedMembers = new Members(members, false);
        return (instance, out) -> initializedMembers.write(instance, new JsonValueWriter(out));
    }

    public static final class Members<T> {
        private final List<Member<?>> members = new ArrayList();
        private final boolean contributesPair;
        private final JsonValueWriter.Series series;
        private final JsonWriterFiltersAndProcessors jsonProcessors = new JsonWriterFiltersAndProcessors();

        Members(Consumer<Members<T>> members, boolean contributesToExistingSeries) {
            Assert.notNull(members, (String)"'members' must not be null");
            members.accept(this);
            Assert.state((!this.members.isEmpty() ? 1 : 0) != 0, (String)"No members have been added");
            this.contributesPair = this.members.stream().anyMatch(Member::contributesPair);
            JsonValueWriter.Series series = this.series = this.contributesPair && !contributesToExistingSeries ? JsonValueWriter.Series.OBJECT : null;
            if (this.contributesPair || this.members.size() > 1) {
                this.members.forEach(member -> Assert.state((boolean)member.contributesPair(), () -> String.format("%s does not contribute a named pair, ensure that all members have a name or call an appropriate 'using' method", member)));
            }
        }

        public Member<T> add(String name) {
            return this.add(name, (T instance) -> instance);
        }

        public <V> Member<V> add(String name, V value) {
            return this.add(name, (T instance) -> value);
        }

        public <V> Member<V> add(String name, Supplier<V> supplier) {
            Assert.notNull(supplier, (String)"'supplier' must not be null");
            return this.add(name, (T instance) -> supplier.get());
        }

        public <V> Member<V> add(String name, Function<T, V> extractor) {
            Assert.notNull((Object)name, (String)"'name' must not be null");
            Assert.notNull(extractor, (String)"'extractor' must not be null");
            return this.addMember(name, extractor);
        }

        public Member<T> add() {
            return this.from(Function.identity());
        }

        public <M extends Map<K, V>, K, V> Member<M> addMapEntries(Function<T, M> extractor) {
            return this.from(extractor).usingPairs(Map::forEach);
        }

        public <V> Member<V> from(V value) {
            return this.from((T instance) -> value);
        }

        public <V> Member<V> from(Supplier<V> supplier) {
            Assert.notNull(supplier, (String)"'supplier' must not be null");
            return this.from((T instance) -> supplier.get());
        }

        public <V> Member<V> from(Function<T, V> extractor) {
            Assert.notNull(extractor, (String)"'extractor' must not be null");
            return this.addMember(null, extractor);
        }

        public void applyingPathFilter(Predicate<MemberPath> predicate) {
            Assert.notNull(predicate, (String)"'predicate' must not be null");
            this.jsonProcessors.pathFilters().add(predicate);
        }

        public void applyingNameProcessor(NameProcessor nameProcessor) {
            Assert.notNull((Object)nameProcessor, (String)"'nameProcessor' must not be null");
            this.jsonProcessors.nameProcessors().add(nameProcessor);
        }

        public void applyingValueProcessor(ValueProcessor<?> valueProcessor) {
            Assert.notNull(valueProcessor, (String)"'valueProcessor' must not be null");
            this.jsonProcessors.valueProcessors().add(valueProcessor);
        }

        private <V> Member<V> addMember(String name, Function<T, V> extractor) {
            Member<V> member = new Member<V>(this.members.size(), name, Member.Extractor.of(extractor));
            this.members.add(member);
            return member;
        }

        void write(T instance, JsonValueWriter valueWriter) {
            valueWriter.pushProcessors(this.jsonProcessors);
            valueWriter.start(this.series);
            for (Member<?> member : this.members) {
                member.write(instance, valueWriter);
            }
            valueWriter.end(this.series);
            valueWriter.popProcessors();
        }

        boolean contributesPair() {
            return this.contributesPair;
        }
    }

    @FunctionalInterface
    public static interface ValueProcessor<T> {
        public T processValue(MemberPath var1, T var2);

        default public ValueProcessor<T> whenHasUnescapedPath(String path) {
            return this.whenHasPath((MemberPath candidate) -> candidate.toString(false).equals(path));
        }

        default public ValueProcessor<T> whenHasPath(String path) {
            return this.whenHasPath(MemberPath.of(path)::equals);
        }

        default public ValueProcessor<T> whenHasPath(Predicate<MemberPath> predicate) {
            return (path, value) -> predicate.test(path) ? this.processValue(path, value) : value;
        }

        default public ValueProcessor<T> whenInstanceOf(Class<?> type) {
            return this.when(type::isInstance);
        }

        default public ValueProcessor<T> when(Predicate<T> predicate) {
            return (name, value) -> predicate.test(value) ? this.processValue(name, value) : value;
        }

        public static <T> ValueProcessor<T> of(Class<? extends T> type, UnaryOperator<T> action) {
            return ValueProcessor.of(action).whenInstanceOf(type);
        }

        public static <T> ValueProcessor<T> of(UnaryOperator<T> action) {
            Assert.notNull(action, (String)"'action' must not be null");
            return (name, value) -> action.apply(value);
        }
    }

    @FunctionalInterface
    public static interface NameProcessor {
        public String processName(MemberPath var1, String var2);

        public static NameProcessor of(UnaryOperator<String> operation) {
            Assert.notNull(operation, (String)"'operation' must not be null");
            return (path, existingName) -> (String)operation.apply(existingName);
        }
    }

    public static interface PairExtractor<E> {
        public <N> N getName(E var1);

        public <V> V getValue(E var1);

        public static <T> PairExtractor<T> of(final Function<T, ?> nameExtractor, final Function<T, ?> valueExtractor) {
            Assert.notNull(nameExtractor, (String)"'nameExtractor' must not be null");
            Assert.notNull(valueExtractor, (String)"'valueExtractor' must not be null");
            return new PairExtractor<T>(){

                @Override
                public <N> N getName(T instance) {
                    return (N)nameExtractor.apply(instance);
                }

                @Override
                public <V> V getValue(T instance) {
                    return (V)valueExtractor.apply(instance);
                }
            };
        }
    }

    public record MemberPath(MemberPath parent, String name, int index) {
        private static final String[] ESCAPED = new String[]{"\\", ".", "[", "]"};
        public static final int UNINDEXED = -1;
        static final MemberPath ROOT = new MemberPath(null, "", -1);

        public MemberPath {
            Assert.isTrue((name != null && index < 0 || name == null && index >= 0 ? 1 : 0) != 0, (String)"'name' and 'index' cannot be mixed");
        }

        public MemberPath child(int index) {
            return new MemberPath(this, null, index);
        }

        public MemberPath child(String name) {
            return !StringUtils.hasLength((String)name) ? this : new MemberPath(this, name, -1);
        }

        @Override
        public final String toString() {
            return this.toString(true);
        }

        public final String toUnescapedString() {
            return this.toString(false);
        }

        private String toString(boolean escape) {
            StringBuilder string = new StringBuilder(this.parent != null ? this.parent.toString(escape) : "");
            if (this.index >= 0) {
                string.append("[").append(this.index).append("]");
            } else {
                string.append(!string.isEmpty() ? "." : "").append(!escape ? this.name : this.escape(this.name));
            }
            return string.toString();
        }

        private String escape(String name) {
            for (String escape : ESCAPED) {
                name = name.replace(escape, "\\" + escape);
            }
            return name;
        }

        public static MemberPath of(String value) {
            MemberPath path = ROOT;
            StringBuilder buffer = new StringBuilder();
            boolean escape = false;
            for (char ch : value.toCharArray()) {
                if (!escape && ch == '\\') {
                    escape = true;
                    continue;
                }
                if (!(escape || ch != '.' && ch != '[')) {
                    path = path.child(buffer.toString());
                    buffer.setLength(0);
                    continue;
                }
                if (!escape && ch == ']') {
                    path = path.child(Integer.parseUnsignedInt(buffer.toString()));
                    buffer.setLength(0);
                    continue;
                }
                buffer.append(ch);
                escape = false;
            }
            path = path.child(buffer.toString());
            return path;
        }
    }

    public static final class Member<T> {
        private final int index;
        private final String name;
        private Extractor<T> extractor;
        private BiConsumer<T, BiConsumer<?, ?>> pairs;
        private Members<T> members;

        Member(int index, String name, Extractor<T> extractor) {
            this.index = index;
            this.name = name;
            this.extractor = extractor;
        }

        public Member<T> whenNotNull() {
            return this.when(Objects::nonNull);
        }

        public Member<T> whenNotNull(Function<T, ?> extractor) {
            Assert.notNull(extractor, (String)"'extractor' must not be null");
            return this.when(instance -> Objects.nonNull(extractor.apply(instance)));
        }

        public Member<T> whenHasLength() {
            return this.when(instance -> instance != null && StringUtils.hasLength((String)instance.toString()));
        }

        public Member<T> whenNotEmpty() {
            return this.whenNot(ObjectUtils::isEmpty);
        }

        public Member<T> whenNot(Predicate<T> predicate) {
            Assert.notNull(predicate, (String)"'predicate' must not be null");
            return this.when(predicate.negate());
        }

        public Member<T> when(Predicate<T> predicate) {
            Assert.notNull(predicate, (String)"'predicate' must not be null");
            this.extractor = this.extractor.when(predicate);
            return this;
        }

        public <R> Member<R> as(Function<T, R> adapter) {
            Assert.notNull(adapter, (String)"'adapter' must not be null");
            Member result = this;
            result.extractor = this.extractor.as(adapter);
            return result;
        }

        public <E> Member<T> usingExtractedPairs(BiConsumer<T, Consumer<E>> elements, PairExtractor<E> extractor) {
            Assert.notNull(elements, (String)"'elements' must not be null");
            Assert.notNull(extractor, (String)"'extractor' must not be null");
            return this.usingExtractedPairs(elements, extractor::getName, extractor::getValue);
        }

        public <E, N, V> Member<T> usingExtractedPairs(BiConsumer<T, Consumer<E>> elements, Function<E, N> nameExtractor, Function<E, V> valueExtractor) {
            Assert.notNull(elements, (String)"'elements' must not be null");
            Assert.notNull(nameExtractor, (String)"'nameExtractor' must not be null");
            Assert.notNull(valueExtractor, (String)"'valueExtractor' must not be null");
            return this.usingPairs((instance, pairsConsumer) -> elements.accept(instance, element -> {
                Object name = nameExtractor.apply(element);
                Object value = valueExtractor.apply(element);
                pairsConsumer.accept(name, value);
            }));
        }

        public <N, V> Member<T> usingPairs(BiConsumer<T, BiConsumer<N, V>> pairs) {
            Assert.notNull(pairs, (String)"'pairs' must not be null");
            Assert.state((this.pairs == null ? 1 : 0) != 0, (String)"Pairs cannot be declared multiple times");
            Assert.state((this.members == null ? 1 : 0) != 0, (String)"Pairs cannot be declared when using members");
            this.pairs = pairs;
            return this;
        }

        public Member<T> usingMembers(Consumer<Members<T>> members) {
            Assert.notNull(members, (String)"'members' must not be null");
            Assert.state((this.members == null ? 1 : 0) != 0, (String)"Members cannot be declared multiple times");
            Assert.state((this.pairs == null ? 1 : 0) != 0, (String)"Members cannot be declared when using pairs");
            this.members = new Members<T>(members, this.name == null);
            return this;
        }

        void write(Object instance, JsonValueWriter valueWriter) {
            T extracted = this.extractor.extract(instance);
            if (Extractor.skip(extracted)) {
                return;
            }
            Object value = this.getValueToWrite(extracted, valueWriter);
            valueWriter.write(this.name, value);
        }

        private Object getValueToWrite(T extracted, JsonValueWriter valueWriter) {
            if (this.pairs != null) {
                return WritableJson.of(out -> valueWriter.writePairs(pairs -> this.pairs.accept(extracted, (BiConsumer<?, ?>)pairs)));
            }
            if (this.members != null) {
                return WritableJson.of(out -> this.members.write(extracted, valueWriter));
            }
            return extracted;
        }

        boolean contributesPair() {
            return this.name != null || this.pairs != null || this.members != null && this.members.contributesPair();
        }

        public String toString() {
            return "Member at index " + this.index + (this.name != null ? "{%s}".formatted(this.name) : "");
        }

        @FunctionalInterface
        static interface Extractor<T> {
            public static final Object SKIP = new Object();

            public T extract(Object var1);

            default public Extractor<T> when(Predicate<T> predicate) {
                return instance -> this.test(this.extract(instance), predicate);
            }

            private T test(T extracted, Predicate<T> predicate) {
                return (T)(!Extractor.skip(extracted) && predicate.test(extracted) ? extracted : SKIP);
            }

            default public <R> Extractor<R> as(Function<T, R> adapter) {
                return instance -> this.apply(this.extract(instance), adapter);
            }

            private <R> R apply(T extracted, Function<T, R> function) {
                if (Extractor.skip(extracted)) {
                    return (R)SKIP;
                }
                return extracted != null ? (R)function.apply(extracted) : null;
            }

            public static <S, T> Extractor<T> of(Function<S, T> extractor) {
                return instance -> !Extractor.skip(instance) ? extractor.apply(instance) : SKIP;
            }

            public static <T> boolean skip(T extracted) {
                return extracted == SKIP;
            }
        }
    }
}

