/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.config;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class FileExtensionHint {
    private static final Pattern PATTERN = Pattern.compile("^(.*)\\[(\\.\\w+)](?!\\[)$");
    private static final FileExtensionHint NONE = new FileExtensionHint(null);
    private final Matcher matcher;

    private FileExtensionHint(Matcher matcher) {
        this.matcher = matcher;
    }

    boolean isPresent() {
        return this.matcher != null;
    }

    String orElse(String extension) {
        return this.matcher != null ? this.toString() : extension;
    }

    public String toString() {
        return this.matcher != null ? this.matcher.group(2) : "";
    }

    static FileExtensionHint from(String value) {
        Matcher matcher = PATTERN.matcher(value);
        return matcher.matches() ? new FileExtensionHint(matcher) : NONE;
    }

    static String removeFrom(String value) {
        Matcher matcher = PATTERN.matcher(value);
        return matcher.matches() ? matcher.group(1) : value;
    }
}

