/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.client;

import java.util.Arrays;
import java.util.List;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.boot.web.client.RestClientCustomizer;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.util.Assert;
import org.springframework.web.client.RestClient;

public class HttpMessageConvertersRestClientCustomizer
implements RestClientCustomizer {
    private final Iterable<? extends HttpMessageConverter<?>> messageConverters;

    public HttpMessageConvertersRestClientCustomizer(HttpMessageConverter<?> ... messageConverters) {
        Assert.notNull(messageConverters, (String)"'messageConverters' must not be null");
        this.messageConverters = Arrays.asList(messageConverters);
    }

    HttpMessageConvertersRestClientCustomizer(HttpMessageConverters messageConverters) {
        this.messageConverters = messageConverters;
    }

    public void customize(RestClient.Builder restClientBuilder) {
        restClientBuilder.messageConverters(this::configureMessageConverters);
    }

    private void configureMessageConverters(List<HttpMessageConverter<?>> messageConverters) {
        if (this.messageConverters != null) {
            messageConverters.clear();
            this.messageConverters.forEach(messageConverters::add);
        }
    }
}

