/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.hazelcast;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.core.HazelcastInstance;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.hazelcast.HazelcastConnectionDetails;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBean(value={HazelcastConnectionDetails.class})
class HazelcastClientInstanceConfiguration {
    HazelcastClientInstanceConfiguration() {
    }

    @Bean
    HazelcastInstance hazelcastInstance(HazelcastConnectionDetails hazelcastConnectionDetails) {
        ClientConfig config = hazelcastConnectionDetails.getClientConfig();
        return !StringUtils.hasText((String)config.getInstanceName()) ? HazelcastClient.newHazelcastClient((ClientConfig)config) : HazelcastClient.getOrCreateHazelcastClient((ClientConfig)config);
    }
}

