/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec.multipart;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.Hints;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ReactiveHttpOutputMessage;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.codec.multipart.FilePart;
import org.springframework.http.codec.multipart.MultipartHttpMessageReader;
import org.springframework.http.codec.multipart.MultipartWriterSupport;
import org.springframework.http.codec.multipart.Part;
import org.springframework.lang.Nullable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PartHttpMessageWriter
extends MultipartWriterSupport
implements HttpMessageWriter<Part> {
    public PartHttpMessageWriter() {
        super(MultipartHttpMessageReader.MIME_TYPES);
    }

    @Override
    public boolean canWrite(ResolvableType elementType, @Nullable MediaType mediaType) {
        if (Part.class.isAssignableFrom(elementType.toClass())) {
            if (mediaType == null) {
                return true;
            }
            for (MediaType supportedMediaType : this.getWritableMediaTypes()) {
                if (!supportedMediaType.isCompatibleWith(mediaType)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Mono<Void> write(Publisher<? extends Part> parts, ResolvableType elementType, @Nullable MediaType mediaType, ReactiveHttpOutputMessage outputMessage, Map<String, Object> hints) {
        byte[] boundary = this.generateMultipartBoundary();
        mediaType = this.getMultipartMediaType(mediaType, boundary);
        outputMessage.getHeaders().setContentType(mediaType);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(Hints.getLogPrefix(hints) + "Encoding Publisher<Part>"));
        }
        Flux body2 = Flux.from(parts).concatMap(part -> this.encodePart(boundary, (Part)part, outputMessage.bufferFactory())).concatWith(this.generateLastLine(boundary, outputMessage.bufferFactory())).doOnDiscard(DataBuffer.class, DataBufferUtils::release);
        if (this.logger.isDebugEnabled()) {
            body2 = body2.doOnNext(buffer -> Hints.touchDataBuffer((DataBuffer)buffer, (Map)hints, (Log)this.logger));
        }
        return outputMessage.writeWith((Publisher<? extends DataBuffer>)body2);
    }

    private <T> Flux<DataBuffer> encodePart(byte[] boundary, Part part, DataBufferFactory bufferFactory) {
        HttpHeaders headers = new HttpHeaders(part.headers());
        String name = part.name();
        if (!headers.containsKey("Content-Disposition")) {
            String string;
            if (part instanceof FilePart) {
                FilePart filePart = (FilePart)part;
                string = filePart.filename();
            } else {
                string = null;
            }
            headers.setContentDispositionFormData(name, string);
        }
        return Flux.concat((Publisher[])new Publisher[]{this.generateBoundaryLine(boundary, bufferFactory), this.generatePartHeaders(headers, bufferFactory), part.content(), this.generateNewLine(bufferFactory)});
    }
}

