/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.xml.processing.validation;

import java.io.IOException;
import java.util.Objects;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.apache.nifi.xml.processing.ProcessingException;
import org.apache.nifi.xml.processing.validation.SchemaValidator;
import org.xml.sax.SAXException;

public class StandardSchemaValidator
implements SchemaValidator {
    private static final boolean SECURE_PROCESSING_ENABLED = true;

    @Override
    public void validate(Schema schema, Source source) {
        Objects.requireNonNull(schema, "Schema required");
        Objects.requireNonNull(source, "Source required");
        Validator validator = schema.newValidator();
        try {
            validator.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (SAXException e) {
            throw new ProcessingException("Validator configuration failed", e);
        }
        try {
            validator.validate(source);
        }
        catch (IOException | SAXException e) {
            throw new ProcessingException(String.format("Validation failed: %s", e.getMessage()), e);
        }
    }
}

