/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.webauthn.management;

import java.util.HashMap;
import java.util.Map;
import org.springframework.security.web.webauthn.api.Bytes;
import org.springframework.security.web.webauthn.api.PublicKeyCredentialUserEntity;
import org.springframework.security.web.webauthn.management.PublicKeyCredentialUserEntityRepository;
import org.springframework.util.Assert;

public class MapPublicKeyCredentialUserEntityRepository
implements PublicKeyCredentialUserEntityRepository {
    private final Map<String, PublicKeyCredentialUserEntity> usernameToUserEntity = new HashMap<String, PublicKeyCredentialUserEntity>();
    private final Map<Bytes, PublicKeyCredentialUserEntity> idToUserEntity = new HashMap<Bytes, PublicKeyCredentialUserEntity>();

    @Override
    public PublicKeyCredentialUserEntity findById(Bytes id) {
        Assert.notNull((Object)id, (String)"id cannot be null");
        return this.idToUserEntity.get(id);
    }

    @Override
    public PublicKeyCredentialUserEntity findByUsername(String username) {
        Assert.notNull((Object)username, (String)"username cannot be null");
        return this.usernameToUserEntity.get(username);
    }

    @Override
    public void save(PublicKeyCredentialUserEntity userEntity) {
        if (userEntity == null) {
            throw new IllegalArgumentException("userEntity cannot be null");
        }
        this.usernameToUserEntity.put(userEntity.getName(), userEntity);
        this.idToUserEntity.put(userEntity.getId(), userEntity);
    }

    @Override
    public void delete(Bytes id) {
        PublicKeyCredentialUserEntity existing = this.idToUserEntity.remove(id);
        if (existing != null) {
            this.usernameToUserEntity.remove(existing.getName());
        }
    }
}

