/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.documentation.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.DynamicRelationship;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.PrimaryNodeOnly;
import org.apache.nifi.annotation.behavior.ReadsAttribute;
import org.apache.nifi.annotation.behavior.Restricted;
import org.apache.nifi.annotation.behavior.Restriction;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.Stateful;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.SupportsSensitiveDynamicProperties;
import org.apache.nifi.annotation.behavior.SystemResourceConsideration;
import org.apache.nifi.annotation.behavior.TriggerSerially;
import org.apache.nifi.annotation.behavior.TriggerWhenAnyDestinationAvailable;
import org.apache.nifi.annotation.behavior.TriggerWhenEmpty;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.configuration.DefaultSchedule;
import org.apache.nifi.annotation.configuration.DefaultSettings;
import org.apache.nifi.annotation.documentation.DeprecationNotice;
import org.apache.nifi.annotation.documentation.MultiProcessorUseCase;
import org.apache.nifi.annotation.documentation.ProcessorConfiguration;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.UseCase;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.PropertyDependency;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.RequiredPermission;
import org.apache.nifi.components.resource.ResourceDefinition;
import org.apache.nifi.components.resource.ResourceType;
import org.apache.nifi.documentation.AbstractDocumentationWriter;
import org.apache.nifi.documentation.ExtensionType;
import org.apache.nifi.documentation.ServiceAPI;
import org.apache.nifi.processor.Relationship;

public class XmlDocumentationWriter
extends AbstractDocumentationWriter {
    private final XMLStreamWriter writer;

    public XmlDocumentationWriter(OutputStream out) throws XMLStreamException {
        this.writer = XMLOutputFactory.newInstance().createXMLStreamWriter(out, "UTF-8");
    }

    public XmlDocumentationWriter(XMLStreamWriter writer) {
        this.writer = writer;
    }

    @Override
    protected void writeHeader(ConfigurableComponent component) throws IOException {
        this.writeStartElement("extension");
    }

    @Override
    protected void writeExtensionName(String extensionName) throws IOException {
        this.writeTextElement("name", extensionName);
    }

    @Override
    protected void writeExtensionType(ExtensionType extensionType) throws IOException {
        this.writeTextElement("type", extensionType.name());
    }

    @Override
    protected void writeDeprecationNotice(DeprecationNotice deprecationNotice) throws IOException {
        if (deprecationNotice == null) {
            return;
        }
        Class<? extends ConfigurableComponent>[] classes = deprecationNotice.alternatives();
        String[] classNames = deprecationNotice.classNames();
        LinkedHashSet<String> alternatives = new LinkedHashSet<String>();
        for (Class<? extends ConfigurableComponent> alternativeClass : classes) {
            alternatives.add(alternativeClass.getName());
        }
        Collections.addAll(alternatives, classNames);
        this.writeDeprecationNotice(deprecationNotice.reason(), alternatives);
    }

    private void writeDeprecationNotice(String reason, Set<String> alternatives) throws IOException {
        this.writeStartElement("deprecationNotice");
        this.writeTextElement("reason", reason);
        this.writeTextArray("alternatives", "alternative", alternatives);
        this.writeEndElement();
    }

    @Override
    protected void writeDescription(String description) throws IOException {
        if (description == null) {
            return;
        }
        this.writeTextElement("description", description);
    }

    @Override
    protected void writeTags(List<String> tags) throws IOException {
        if (tags == null) {
            return;
        }
        this.writeTextArray("tags", "tag", tags);
    }

    @Override
    protected void writeProperties(List<PropertyDescriptor> properties, Map<String, ServiceAPI> propertyServices) throws IOException {
        if (properties == null || properties.isEmpty()) {
            return;
        }
        this.writeStartElement("properties");
        for (PropertyDescriptor property : properties) {
            this.writeProperty(property, propertyServices);
        }
        this.writeEndElement();
    }

    private void writeProperty(PropertyDescriptor property, Map<String, ServiceAPI> propertyServices) throws IOException {
        this.writeStartElement("property");
        this.writeTextElement("name", property.getName());
        this.writeTextElement("displayName", property.getDisplayName());
        this.writeTextElement("description", property.getDescription());
        if (property.getDefaultValue() != null) {
            this.writeTextElement("defaultValue", property.getDefaultValue());
        }
        if (property.getControllerServiceDefinition() != null) {
            this.writeStartElement("controllerServiceDefinition");
            ServiceAPI serviceAPI = propertyServices.get(property.getName());
            if (serviceAPI != null) {
                this.writeTextElement("className", serviceAPI.getClassName());
                this.writeTextElement("groupId", serviceAPI.getGroupId());
                this.writeTextElement("artifactId", serviceAPI.getArtifactId());
                this.writeTextElement("version", serviceAPI.getVersion());
            } else {
                this.writeTextElement("className", property.getControllerServiceDefinition().getName());
                this.writeTextElement("groupId", "unknown");
                this.writeTextElement("artifactId", "unknown");
                this.writeTextElement("version", "unknown");
            }
            this.writeEndElement();
        }
        if (property.getAllowableValues() != null && !property.getAllowableValues().isEmpty()) {
            this.writeArray("allowableValues", property.getAllowableValues(), this::writeAllowableValue);
        }
        this.writeBooleanElement("required", property.isRequired());
        this.writeBooleanElement("sensitive", property.isSensitive());
        this.writeBooleanElement("expressionLanguageSupported", property.isExpressionLanguageSupported());
        if (property.getExpressionLanguageScope() != null) {
            this.writeTextElement("expressionLanguageScope", property.getExpressionLanguageScope().name());
        }
        this.writeBooleanElement("dynamicallyModifiesClasspath", property.isDynamicClasspathModifier());
        this.writeBooleanElement("dynamic", property.isDynamic());
        this.writeResourceDefinition(property.getResourceDefinition());
        this.writeDependencies(property);
        this.writeEndElement();
    }

    private void writeResourceDefinition(ResourceDefinition resourceDefinition) throws IOException {
        if (resourceDefinition == null) {
            return;
        }
        this.writeStartElement("resourceDefinition");
        this.writeTextElement("cardinality", resourceDefinition.getCardinality().name());
        Set<ResourceType> resourceTypes = resourceDefinition.getResourceTypes();
        if (resourceTypes == null) {
            this.writeArray("resourceTypes", null, this::writeResourceType);
        } else {
            TreeSet<ResourceType> orderedResourceTypes = new TreeSet<ResourceType>(Comparator.comparing(Enum::name));
            orderedResourceTypes.addAll(resourceTypes);
            this.writeArray("resourceTypes", orderedResourceTypes, this::writeResourceType);
        }
        this.writeEndElement();
    }

    private void writeResourceType(ResourceType resourceType) throws IOException {
        this.writeTextElement("resourceType", resourceType.name());
    }

    private void writeAllowableValue(AllowableValue allowableValue) throws IOException {
        this.writeStartElement("allowableValue");
        this.writeTextElement("displayName", allowableValue.getDisplayName());
        this.writeTextElement("value", allowableValue.getValue());
        this.writeTextElement("description", allowableValue.getDescription());
        this.writeEndElement();
    }

    private void writeDependencies(PropertyDescriptor propertyDescriptor) throws IOException {
        Set<PropertyDependency> dependencies = propertyDescriptor.getDependencies();
        if (dependencies == null || dependencies.isEmpty()) {
            return;
        }
        this.writeStartElement("dependencies");
        TreeSet<PropertyDependency> orderedDependencies = new TreeSet<PropertyDependency>(Comparator.comparing(PropertyDependency::getPropertyName));
        orderedDependencies.addAll(dependencies);
        for (PropertyDependency dependency : orderedDependencies) {
            this.writeStartElement("dependency");
            this.writeTextElement("propertyName", dependency.getPropertyName());
            this.writeTextElement("propertyDisplayName", dependency.getPropertyDisplayName());
            Set<String> dependentValues = dependency.getDependentValues();
            if (dependentValues != null) {
                this.writeStartElement("dependentValues");
                TreeSet<String> orderedDependentValues = new TreeSet<String>(dependentValues);
                for (String dependentValue : orderedDependentValues) {
                    this.writeTextElement("dependentValue", dependentValue);
                }
                this.writeEndElement();
            }
            this.writeEndElement();
        }
        this.writeEndElement();
    }

    @Override
    protected void writeDynamicProperties(List<DynamicProperty> dynamicProperties) throws IOException {
        if (dynamicProperties == null || dynamicProperties.isEmpty()) {
            return;
        }
        this.writeArray("dynamicProperties", dynamicProperties, this::writeDynamicProperty);
    }

    private void writeDynamicProperty(DynamicProperty property) throws IOException {
        this.writeStartElement("dynamicProperty");
        this.writeTextElement("name", property.name());
        this.writeTextElement("value", property.value());
        this.writeTextElement("description", property.description());
        this.writeTextElement("expressionLanguageScope", property.expressionLanguageScope() == null ? null : property.expressionLanguageScope().name());
        this.writeEndElement();
    }

    @Override
    protected void writeStatefulInfo(Stateful stateful) throws IOException {
        if (stateful == null) {
            return;
        }
        this.writeStartElement("stateful");
        this.writeTextElement("description", stateful.description());
        this.writeArray("scopes", Arrays.asList(stateful.scopes()), scope -> this.writeTextElement("scope", scope.name()));
        this.writeEndElement();
    }

    @Override
    protected void writeRestrictedInfo(Restricted restricted) throws IOException {
        Restriction[] restrictions;
        if (restricted == null) {
            return;
        }
        this.writeStartElement("restricted");
        if (restricted.value() != null && !restricted.value().isEmpty()) {
            this.writeTextElement("generalRestrictionExplanation", restricted.value());
        }
        if ((restrictions = restricted.restrictions()) != null) {
            this.writeArray("restrictions", Arrays.asList(restrictions), this::writeRestriction);
        }
        this.writeEndElement();
    }

    private void writeRestriction(Restriction restriction) throws IOException {
        this.writeStartElement("restriction");
        RequiredPermission permission = restriction.requiredPermission();
        String label = permission == null ? null : permission.getPermissionLabel();
        this.writeTextElement("requiredPermission", label);
        this.writeTextElement("explanation", restriction.explanation());
        this.writeEndElement();
    }

    @Override
    protected void writeInputRequirementInfo(InputRequirement.Requirement requirement) throws IOException {
        if (requirement == null) {
            return;
        }
        this.writeTextElement("inputRequirement", requirement.name());
    }

    @Override
    protected void writeSystemResourceConsiderationInfo(List<SystemResourceConsideration> considerations) throws IOException {
        if (considerations == null || considerations.isEmpty()) {
            return;
        }
        this.writeArray("systemResourceConsiderations", considerations, this::writeSystemResourceConsideration);
    }

    private void writeSystemResourceConsideration(SystemResourceConsideration consideration) throws IOException {
        this.writeStartElement("systemResourceConsideration");
        this.writeTextElement("resource", consideration.resource() == null ? null : consideration.resource().name());
        this.writeTextElement("description", consideration.description());
        this.writeEndElement();
    }

    @Override
    protected void writeSeeAlso(SeeAlso seeAlso) throws IOException {
        if (seeAlso == null) {
            return;
        }
        Class<? extends ConfigurableComponent>[] classes = seeAlso.value();
        String[] classNames = seeAlso.classNames();
        LinkedHashSet<String> toSee = new LinkedHashSet<String>();
        if (classes != null) {
            for (Class<? extends ConfigurableComponent> classToSee : classes) {
                toSee.add(classToSee.getName());
            }
        }
        if (classNames != null) {
            Collections.addAll(toSee, classNames);
        }
        this.writeTextArray("seeAlso", "see", toSee);
    }

    @Override
    protected void writeUseCases(List<UseCase> useCases) throws IOException {
        if (useCases.isEmpty()) {
            return;
        }
        this.writeArray("useCases", useCases, this::writeUseCase);
    }

    private void writeUseCase(UseCase useCase) throws IOException {
        this.writeStartElement("useCase");
        this.writeTextElement("description", useCase.description());
        this.writeTextElement("notes", useCase.notes());
        this.writeTextArray("keywords", "keyword", Arrays.asList(useCase.keywords()));
        this.writeTextElement("inputRequirement", useCase.inputRequirement().name());
        this.writeTextElement("configuration", useCase.configuration());
        this.writeEndElement();
    }

    @Override
    protected void writeMultiProcessorUseCases(List<MultiProcessorUseCase> multiProcessorUseCases) throws IOException {
        if (multiProcessorUseCases.isEmpty()) {
            return;
        }
        this.writeArray("multiProcessorUseCases", multiProcessorUseCases, this::writeMultiProcessorUseCase);
    }

    private void writeMultiProcessorUseCase(MultiProcessorUseCase useCase) throws IOException {
        this.writeStartElement("multiProcessorUseCase");
        this.writeTextElement("description", useCase.description());
        this.writeTextElement("notes", useCase.notes());
        this.writeTextArray("keywords", "keyword", Arrays.asList(useCase.keywords()));
        this.writeArray("processorConfigurations", Arrays.asList(useCase.configurations()), this::writeUseCaseComponent);
        this.writeEndElement();
    }

    private void writeUseCaseComponent(ProcessorConfiguration processorConfig) throws IOException {
        this.writeStartElement("processorConfiguration");
        String processorClassName = processorConfig.processorClassName();
        if (processorClassName.isEmpty()) {
            processorClassName = processorConfig.processorClass().getName();
        }
        this.writeTextElement("processorClassName", processorClassName);
        this.writeTextElement("configuration", processorConfig.configuration());
        this.writeEndElement();
    }

    @Override
    protected void writeRelationships(Set<Relationship> relationships) throws IOException {
        if (relationships == null || relationships.isEmpty()) {
            return;
        }
        TreeSet<Relationship> ordered = new TreeSet<Relationship>(Comparator.comparing(Relationship::getName));
        ordered.addAll(relationships);
        this.writeArray("relationships", ordered, rel -> {
            this.writeStartElement("relationship");
            this.writeTextElement("name", rel.getName());
            this.writeTextElement("description", rel.getDescription());
            this.writeBooleanElement("autoTerminated", rel.isAutoTerminated());
            this.writeEndElement();
        });
    }

    @Override
    protected void writeDynamicRelationship(DynamicRelationship dynamicRelationship) throws IOException {
        if (dynamicRelationship == null) {
            return;
        }
        this.writeStartElement("dynamicRelationship");
        this.writeTextElement("name", dynamicRelationship.name());
        this.writeTextElement("description", dynamicRelationship.description());
        this.writeEndElement();
    }

    @Override
    protected void writeReadsAttributes(List<ReadsAttribute> attributes) throws IOException {
        if (attributes == null || attributes.isEmpty()) {
            return;
        }
        this.writeArray("readsAttributes", attributes, this::writeReadsAttribute);
    }

    private void writeReadsAttribute(ReadsAttribute attribute) throws IOException {
        this.writeStartElement("readsAttribute");
        this.writeTextElement("name", attribute.attribute());
        this.writeTextElement("description", attribute.description());
        this.writeEndElement();
    }

    @Override
    protected void writeWritesAttributes(List<WritesAttribute> attributes) throws IOException {
        if (attributes == null) {
            return;
        }
        this.writeArray("writesAttributes", attributes, this::writeWritesAttribute);
    }

    private void writeWritesAttribute(WritesAttribute attribute) throws IOException {
        this.writeStartElement("writesAttribute");
        this.writeTextElement("name", attribute.attribute());
        this.writeTextElement("description", attribute.description());
        this.writeEndElement();
    }

    @Override
    protected void writeTriggerSerially(TriggerSerially triggerSerially) throws IOException {
        if (triggerSerially == null) {
            return;
        }
        this.writeBooleanElement("triggerSerially", true);
    }

    @Override
    protected void writeTriggerWhenEmpty(TriggerWhenEmpty triggerWhenEmpty) throws IOException {
        if (triggerWhenEmpty == null) {
            return;
        }
        this.writeBooleanElement("triggerWhenEmpty", true);
    }

    @Override
    protected void writeTriggerWhenAnyDestinationAvailable(TriggerWhenAnyDestinationAvailable triggerWhenAnyDestinationAvailable) throws IOException {
        if (triggerWhenAnyDestinationAvailable == null) {
            return;
        }
        this.writeBooleanElement("triggerWhenAnyDestinationAvailable", true);
    }

    @Override
    protected void writeSupportsBatching(SupportsBatching supportsBatching) throws IOException {
        if (supportsBatching == null) {
            return;
        }
        this.writeBooleanElement("supportsBatching", true);
    }

    @Override
    protected void writeSupportsSensitiveDynamicProperties(SupportsSensitiveDynamicProperties supportsSensitiveDynamicProperties) throws IOException {
        if (supportsSensitiveDynamicProperties == null) {
            return;
        }
        this.writeBooleanElement("supportsSensitiveDynamicProperties", true);
    }

    @Override
    protected void writePrimaryNodeOnly(PrimaryNodeOnly primaryNodeOnly) throws IOException {
        if (primaryNodeOnly == null) {
            return;
        }
        this.writeBooleanElement("primaryNodeOnly", true);
    }

    @Override
    protected void writeSideEffectFree(SideEffectFree sideEffectFree) throws IOException {
        if (sideEffectFree == null) {
            return;
        }
        this.writeBooleanElement("sideEffectFree", true);
    }

    @Override
    protected void writeDefaultSchedule(DefaultSchedule defaultSchedule) throws IOException {
        if (defaultSchedule == null) {
            return;
        }
        this.writeStartElement("defaultSchedule");
        this.writeTextElement("strategy", defaultSchedule.strategy().name());
        this.writeTextElement("period", defaultSchedule.period());
        this.writeTextElement("concurrentTasks", String.valueOf(defaultSchedule.concurrentTasks()));
        this.writeEndElement();
    }

    @Override
    protected void writeDefaultSettings(DefaultSettings defaultSettings) throws IOException {
        if (defaultSettings == null) {
            return;
        }
        this.writeStartElement("defaultSettings");
        this.writeTextElement("yieldDuration", defaultSettings.yieldDuration());
        this.writeTextElement("penaltyDuration", defaultSettings.penaltyDuration());
        this.writeTextElement("bulletinLevel", defaultSettings.bulletinLevel().name());
        this.writeEndElement();
    }

    @Override
    protected void writeFooter(ConfigurableComponent component) throws IOException {
        this.writeEndElement();
    }

    @Override
    protected void writeProvidedServices(Collection<ServiceAPI> providedServices) throws IOException {
        if (providedServices == null || providedServices.isEmpty()) {
            return;
        }
        this.writeArray("providedServiceAPIs", providedServices, this::writeProvidedService);
    }

    private void writeProvidedService(ServiceAPI service) throws IOException {
        this.writeStartElement("providedServiceAPI");
        this.writeTextElement("className", service.getClassName());
        this.writeTextElement("groupId", service.getGroupId());
        this.writeTextElement("artifactId", service.getArtifactId());
        this.writeTextElement("version", service.getVersion());
        this.writeEndElement();
    }

    private <T> void writeArray(String tagName, Collection<T> values, ElementWriter<T> writer) throws IOException {
        this.writeStartElement(tagName);
        if (values != null) {
            for (T value : values) {
                writer.write(value);
            }
        }
        this.writeEndElement();
    }

    private void writeTextArray(String outerTagName, String elementTagName, Collection<String> values) throws IOException {
        this.writeTextArray(outerTagName, elementTagName, values, String::toString);
    }

    private <T> void writeTextArray(String outerTagName, String elementTagName, Collection<T> values, Function<T, String> transform) throws IOException {
        this.writeStartElement(outerTagName);
        if (values != null) {
            for (T value : values) {
                this.writeStartElement(elementTagName);
                if (value != null) {
                    this.writeText(transform.apply(value));
                }
                this.writeEndElement();
            }
        }
        this.writeEndElement();
    }

    private void writeText(String text) throws IOException {
        if (text == null) {
            return;
        }
        try {
            this.writer.writeCharacters(text);
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    private void writeStartElement(String elementName) throws IOException {
        try {
            this.writer.writeStartElement(elementName);
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    private void writeEndElement() throws IOException {
        try {
            this.writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    private void writeTextElement(String name, String text) throws IOException {
        this.writeStartElement(name);
        this.writeText(text);
        this.writeEndElement();
    }

    private void writeBooleanElement(String name, boolean value) throws IOException {
        this.writeTextElement(name, String.valueOf(value));
    }

    private static interface ElementWriter<T> {
        public void write(T var1) throws IOException;
    }
}

