/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.api.exception;

import org.bouncycastle.openpgp.api.OpenPGPCertificate;
import org.bouncycastle.openpgp.api.exception.OpenPGPKeyException;

public class InvalidEncryptionKeyException
extends OpenPGPKeyException {
    public InvalidEncryptionKeyException(OpenPGPCertificate openPGPCertificate) {
        super(openPGPCertificate, "Certificate " + openPGPCertificate.getKeyIdentifier() + " does not contain any usable subkeys capable of encryption.");
    }

    public InvalidEncryptionKeyException(OpenPGPCertificate.OpenPGPComponentKey openPGPComponentKey) {
        super(openPGPComponentKey, InvalidEncryptionKeyException.componentKeyErrorMessage(openPGPComponentKey));
    }

    private static String componentKeyErrorMessage(OpenPGPCertificate.OpenPGPComponentKey openPGPComponentKey) {
        if (openPGPComponentKey.getKeyIdentifier().equals(openPGPComponentKey.getCertificate().getKeyIdentifier())) {
            return "The primary key " + openPGPComponentKey.getKeyIdentifier() + " is not usable for encryption.";
        }
        return "The subkey " + openPGPComponentKey.getKeyIdentifier() + " from the certificate " + openPGPComponentKey.getCertificate().getKeyIdentifier() + " is not usable for encryption.";
    }
}

