/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.security.identity;

import java.util.Collections;
import java.util.List;
import org.apache.nifi.registry.properties.NiFiRegistryProperties;
import org.apache.nifi.registry.properties.util.IdentityMapping;
import org.apache.nifi.registry.properties.util.IdentityMappingUtil;
import org.apache.nifi.registry.security.identity.IdentityMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultIdentityMapper
implements IdentityMapper {
    final List<IdentityMapping> userIdentityMappings;
    final List<IdentityMapping> groupMappings;

    @Autowired
    public DefaultIdentityMapper(NiFiRegistryProperties properties) {
        this.userIdentityMappings = Collections.unmodifiableList(IdentityMappingUtil.getIdentityMappings((NiFiRegistryProperties)properties));
        this.groupMappings = Collections.unmodifiableList(IdentityMappingUtil.getGroupMappings((NiFiRegistryProperties)properties));
    }

    @Override
    public String mapUser(String userIdentity) {
        return IdentityMappingUtil.mapIdentity((String)userIdentity, this.userIdentityMappings);
    }

    @Override
    public String mapGroup(String groupName) {
        return IdentityMappingUtil.mapIdentity((String)groupName, this.groupMappings);
    }
}

