/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.security.authentication;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.registry.extension.ExtensionClassLoader;
import org.apache.nifi.registry.extension.ExtensionManager;
import org.apache.nifi.registry.properties.NiFiRegistryProperties;
import org.apache.nifi.registry.security.authentication.IdentityProvider;
import org.apache.nifi.registry.security.authentication.IdentityProviderConfigurationContext;
import org.apache.nifi.registry.security.authentication.IdentityProviderLookup;
import org.apache.nifi.registry.security.authentication.StandardIdentityProviderConfigurationContext;
import org.apache.nifi.registry.security.authentication.annotation.IdentityProviderContext;
import org.apache.nifi.registry.security.authentication.generated.IdentityProviders;
import org.apache.nifi.registry.security.authentication.generated.Property;
import org.apache.nifi.registry.security.authentication.generated.Provider;
import org.apache.nifi.xml.processing.stream.StandardXMLStreamReaderProvider;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.xml.sax.SAXException;

@Configuration
public class IdentityProviderFactory
implements IdentityProviderLookup,
DisposableBean {
    private static final String LOGIN_IDENTITY_PROVIDERS_XSD = "/identity-providers.xsd";
    private static final String JAXB_GENERATED_PATH = "org.apache.nifi.registry.security.authentication.generated";
    private static final JAXBContext JAXB_CONTEXT = IdentityProviderFactory.initializeJaxbContext();
    private final NiFiRegistryProperties properties;
    private final ExtensionManager extensionManager;
    private IdentityProvider identityProvider;
    private final Map<String, IdentityProvider> identityProviders = new HashMap<String, IdentityProvider>();

    private static JAXBContext initializeJaxbContext() {
        try {
            return JAXBContext.newInstance((String)JAXB_GENERATED_PATH, (ClassLoader)IdentityProviderFactory.class.getClassLoader());
        }
        catch (JAXBException e) {
            throw new RuntimeException("Unable to create JAXBContext.");
        }
    }

    @Autowired
    public IdentityProviderFactory(NiFiRegistryProperties properties, ExtensionManager extensionManager) {
        this.properties = properties;
        this.extensionManager = extensionManager;
        if (this.properties == null) {
            throw new IllegalStateException("NiFiRegistryProperties cannot be null");
        }
        if (this.extensionManager == null) {
            throw new IllegalStateException("ExtensionManager cannot be null");
        }
    }

    public IdentityProvider getIdentityProvider(String identifier) {
        return this.identityProviders.get(identifier);
    }

    @Bean
    @Primary
    public IdentityProvider getIdentityProvider() throws Exception {
        String loginIdentityProviderIdentifier;
        if (this.identityProvider == null && StringUtils.isNotBlank((CharSequence)(loginIdentityProviderIdentifier = this.properties.getProperty("nifi.registry.security.identity.provider")))) {
            IdentityProviders loginIdentityProviderConfiguration = this.loadLoginIdentityProvidersConfiguration();
            for (Provider provider : loginIdentityProviderConfiguration.getProvider()) {
                this.identityProviders.put(provider.getIdentifier(), this.createLoginIdentityProvider(provider.getClazz()));
            }
            for (Provider provider : loginIdentityProviderConfiguration.getProvider()) {
                IdentityProvider instance = this.identityProviders.get(provider.getIdentifier());
                instance.onConfigured(this.loadLoginIdentityProviderConfiguration(provider));
            }
            this.identityProvider = this.getIdentityProvider(loginIdentityProviderIdentifier);
            if (this.identityProvider == null) {
                throw new Exception(String.format("The specified login identity provider '%s' could not be found.", loginIdentityProviderIdentifier));
            }
        }
        return this.identityProvider;
    }

    public void destroy() {
        this.identityProviders.forEach((key, value) -> value.preDestruction());
    }

    private IdentityProviders loadLoginIdentityProvidersConfiguration() throws Exception {
        File loginIdentityProvidersConfigurationFile = this.properties.getIdentityProviderConfigurationFile();
        if (loginIdentityProvidersConfigurationFile.exists()) {
            try {
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                Schema schema = schemaFactory.newSchema(IdentityProviders.class.getResource(LOGIN_IDENTITY_PROVIDERS_XSD));
                StandardXMLStreamReaderProvider provider = new StandardXMLStreamReaderProvider();
                XMLStreamReader xsr = provider.getStreamReader(new StreamSource(loginIdentityProvidersConfigurationFile));
                Unmarshaller unmarshaller = JAXB_CONTEXT.createUnmarshaller();
                unmarshaller.setSchema(schema);
                JAXBElement element = unmarshaller.unmarshal(xsr, IdentityProviders.class);
                return (IdentityProviders)element.getValue();
            }
            catch (JAXBException | SAXException e) {
                throw new Exception("Unable to load the login identity provider configuration file at: " + loginIdentityProvidersConfigurationFile.getAbsolutePath());
            }
        }
        throw new Exception("Unable to find the login identity provider configuration file at " + loginIdentityProvidersConfigurationFile.getAbsolutePath());
    }

    private IdentityProvider createLoginIdentityProvider(String loginIdentityProviderClassName) throws Exception {
        ExtensionClassLoader classLoader = this.extensionManager.getExtensionClassLoader(loginIdentityProviderClassName);
        if (classLoader == null) {
            throw new IllegalStateException("Extension not found in any of the configured class loaders: " + loginIdentityProviderClassName);
        }
        Class<?> rawLoginIdentityProviderClass = Class.forName(loginIdentityProviderClassName, true, classLoader);
        Class<IdentityProvider> loginIdentityProviderClass = rawLoginIdentityProviderClass.asSubclass(IdentityProvider.class);
        Constructor<IdentityProvider> constructor = loginIdentityProviderClass.getConstructor(new Class[0]);
        IdentityProvider instance = constructor.newInstance(new Object[0]);
        this.performMethodInjection(instance, loginIdentityProviderClass);
        this.performFieldInjection(instance, loginIdentityProviderClass);
        return instance;
    }

    private IdentityProviderConfigurationContext loadLoginIdentityProviderConfiguration(Provider provider) {
        HashMap<String, String> providerProperties = new HashMap<String, String>();
        for (Property property : provider.getProperty()) {
            providerProperties.put(property.getName(), property.getValue());
        }
        return new StandardIdentityProviderConfigurationContext(provider.getIdentifier(), this, providerProperties);
    }

    private void performMethodInjection(IdentityProvider instance, Class<?> loginIdentityProviderClass) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        for (Method method : loginIdentityProviderClass.getMethods()) {
            Class<?> argumentType;
            if (!method.isAnnotationPresent(IdentityProviderContext.class)) continue;
            method.setAccessible(true);
            Class<?>[] argumentTypes = method.getParameterTypes();
            if (argumentTypes.length != 1 || !NiFiRegistryProperties.class.isAssignableFrom(argumentType = argumentTypes[0])) continue;
            method.invoke((Object)instance, this.properties);
        }
        Class<?> parentClass = loginIdentityProviderClass.getSuperclass();
        if (parentClass != null && IdentityProvider.class.isAssignableFrom(parentClass)) {
            this.performMethodInjection(instance, parentClass);
        }
    }

    private void performFieldInjection(IdentityProvider instance, Class<?> loginIdentityProviderClass) throws IllegalArgumentException, IllegalAccessException {
        for (Field field : loginIdentityProviderClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(IdentityProviderContext.class)) continue;
            field.setAccessible(true);
            Class<?> fieldType = field.getType();
            if (field.get(instance) != null || !NiFiRegistryProperties.class.isAssignableFrom(fieldType)) continue;
            field.set(instance, this.properties);
        }
        Class<?> parentClass = loginIdentityProviderClass.getSuperclass();
        if (parentClass != null && IdentityProvider.class.isAssignableFrom(parentClass)) {
            this.performFieldInjection(instance, parentClass);
        }
    }
}

