/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.db;

import java.io.File;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.registry.db.DatabaseMetadataService;
import org.apache.nifi.registry.db.entity.BucketEntity;
import org.apache.nifi.registry.db.entity.FlowEntity;
import org.apache.nifi.registry.db.entity.FlowSnapshotEntity;
import org.apache.nifi.registry.db.migration.BucketEntityV1;
import org.apache.nifi.registry.db.migration.FlowEntityV1;
import org.apache.nifi.registry.db.migration.FlowSnapshotEntityV1;
import org.apache.nifi.registry.db.migration.LegacyDataSourceFactory;
import org.apache.nifi.registry.db.migration.LegacyDatabaseService;
import org.apache.nifi.registry.db.migration.LegacyEntityMapper;
import org.apache.nifi.registry.properties.NiFiRegistryProperties;
import org.flywaydb.core.Flyway;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.flyway.FlywayMigrationStrategy;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Component
public class CustomFlywayMigrationStrategy
implements FlywayMigrationStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomFlywayMigrationStrategy.class);
    private NiFiRegistryProperties properties;

    @Autowired
    public CustomFlywayMigrationStrategy(NiFiRegistryProperties properties) {
        this.properties = properties;
    }

    public void migrate(Flyway flyway) {
        boolean newDatabase = this.isNewDatabase(flyway.getConfiguration().getDataSource());
        if (newDatabase) {
            LOGGER.info("First time initializing database...");
        } else {
            LOGGER.info("Found existing database...");
        }
        boolean existingLegacyDatabase = false;
        if (!StringUtils.isBlank((CharSequence)this.properties.getLegacyDatabaseDirectory())) {
            LOGGER.info("Found legacy database properties...");
            File legacyDatabaseFile = new File(this.properties.getLegacyDatabaseDirectory(), "nifi-registry.mv.db");
            if (legacyDatabaseFile.exists()) {
                LOGGER.info("Found legacy database file...");
                existingLegacyDatabase = true;
            } else {
                LOGGER.info("Did not find legacy database file...");
                existingLegacyDatabase = false;
            }
        }
        flyway.migrate();
        if (newDatabase && existingLegacyDatabase) {
            LegacyDataSourceFactory legacyDataSourceFactory = new LegacyDataSourceFactory(this.properties);
            DataSource legacyDataSource = legacyDataSourceFactory.getDataSource();
            DataSource primaryDataSource = flyway.getConfiguration().getDataSource();
            this.migrateData(legacyDataSource, primaryDataSource);
        }
    }

    /*
     * Exception decompiling
     */
    private boolean isNewDatabase(DataSource dataSource) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void migrateData(DataSource source, DataSource dest) {
        LegacyDatabaseService legacyDatabaseService = new LegacyDatabaseService(source);
        JdbcTemplate destJdbcTemplate = new JdbcTemplate(dest);
        DatabaseMetadataService destMetadataService = new DatabaseMetadataService(destJdbcTemplate);
        LOGGER.info("Migrating data from legacy database to new new database...");
        List<BucketEntityV1> sourceBuckets = legacyDatabaseService.getAllBuckets();
        LOGGER.info("Migrating {} buckets..", (Object)sourceBuckets.size());
        sourceBuckets.stream().map(b -> LegacyEntityMapper.createBucketEntity(b)).forEach(b -> destMetadataService.createBucket((BucketEntity)b));
        List<FlowEntityV1> sourceFlows = legacyDatabaseService.getAllFlows();
        LOGGER.info("Migrating {} flows..", (Object)sourceFlows.size());
        sourceFlows.stream().map(f -> LegacyEntityMapper.createFlowEntity(f)).forEach(f -> destMetadataService.createFlow((FlowEntity)f));
        List<FlowSnapshotEntityV1> sourceSnapshots = legacyDatabaseService.getAllFlowSnapshots();
        LOGGER.info("Migrating {} flow snapshots..", (Object)sourceSnapshots.size());
        sourceSnapshots.stream().map(fs -> LegacyEntityMapper.createFlowSnapshotEntity(fs)).forEach(fs -> destMetadataService.createFlowSnapshot((FlowSnapshotEntity)fs));
        LOGGER.info("Data migration complete!");
    }
}

