/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.parser;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.ErrorCode;
import org.eclipse.jetty.http2.frames.PushPromiseFrame;
import org.eclipse.jetty.http2.hpack.HpackException;
import org.eclipse.jetty.http2.parser.BodyParser;
import org.eclipse.jetty.http2.parser.HeaderBlockParser;
import org.eclipse.jetty.http2.parser.HeaderParser;
import org.eclipse.jetty.http2.parser.Parser;

public class PushPromiseBodyParser
extends BodyParser {
    private final HeaderBlockParser headerBlockParser;
    private State state = State.PREPARE;
    private int cursor;
    private int length;
    private int paddingLength;
    private int streamId;

    public PushPromiseBodyParser(HeaderParser headerParser, Parser.Listener listener, HeaderBlockParser headerBlockParser) {
        super(headerParser, listener);
        this.headerBlockParser = headerBlockParser;
    }

    private void reset() {
        this.state = State.PREPARE;
        this.cursor = 0;
        this.length = 0;
        this.paddingLength = 0;
        this.streamId = 0;
    }

    @Override
    public boolean parse(ByteBuffer buffer) {
        boolean loop = false;
        block8: while (buffer.hasRemaining() || loop) {
            switch (this.state.ordinal()) {
                case 0: {
                    if (this.getStreamId() == 0) {
                        return this.connectionFailure(buffer, ErrorCode.PROTOCOL_ERROR.code, "invalid_push_promise_frame");
                    }
                    if (!this.hasFlag(4)) {
                        return this.connectionFailure(buffer, ErrorCode.INTERNAL_ERROR.code, "unsupported_push_promise_frame");
                    }
                    this.length = this.getBodyLength();
                    if (this.isPadding()) {
                        this.state = State.PADDING_LENGTH;
                        continue block8;
                    }
                    this.state = State.STREAM_ID;
                    continue block8;
                }
                case 1: {
                    if (this.length < 1) {
                        return this.connectionFailure(buffer, ErrorCode.FRAME_SIZE_ERROR.code, "invalid_push_promise_frame");
                    }
                    this.paddingLength = buffer.get() & 0xFF;
                    --this.length;
                    this.length -= this.paddingLength;
                    this.state = State.STREAM_ID;
                    continue block8;
                }
                case 2: {
                    if (this.length < 4) {
                        return this.connectionFailure(buffer, ErrorCode.FRAME_SIZE_ERROR.code, "invalid_push_promise_frame");
                    }
                    if (buffer.remaining() >= 4) {
                        this.streamId = buffer.getInt();
                        this.streamId &= Integer.MAX_VALUE;
                        this.length -= 4;
                        this.state = State.HEADERS;
                        loop = this.length == 0;
                        continue block8;
                    }
                    this.state = State.STREAM_ID_BYTES;
                    this.cursor = 4;
                    continue block8;
                }
                case 3: {
                    int currByte = buffer.get() & 0xFF;
                    --this.cursor;
                    this.streamId += currByte << 8 * this.cursor;
                    --this.length;
                    if (this.cursor != 0) continue block8;
                    this.streamId &= Integer.MAX_VALUE;
                    this.state = State.HEADERS;
                    loop = this.length == 0;
                    continue block8;
                }
                case 4: {
                    int maxLength = this.headerBlockParser.getMaxHeaderListSize();
                    if (maxLength > 0 && this.length > maxLength) {
                        return this.connectionFailure(buffer, ErrorCode.REFUSED_STREAM_ERROR.code, "invalid_headers_frame");
                    }
                    MetaData metaData = this.headerBlockParser.parse(buffer, this.length);
                    if (metaData == null) continue block8;
                    Throwable metaDataFailure = MetaData.Failed.getFailure((MetaData)metaData);
                    if (metaDataFailure instanceof HpackException.SessionException) {
                        return false;
                    }
                    this.state = State.PADDING;
                    boolean bl = loop = this.paddingLength == 0;
                    if (metaDataFailure != null) {
                        PushPromiseFrame frame = new PushPromiseFrame(this.getStreamId(), this.streamId, (MetaData.Request)metaData);
                        if (!this.rateControlOnEvent(frame)) {
                            return this.connectionFailure(buffer, ErrorCode.ENHANCE_YOUR_CALM_ERROR.code, "invalid_push_promise_frame_rate");
                        }
                        this.onPushPromise(frame);
                        continue block8;
                    }
                    this.onPushPromise((MetaData.Request)metaData);
                    continue block8;
                }
                case 5: {
                    int size = Math.min(buffer.remaining(), this.paddingLength);
                    buffer.position(buffer.position() + size);
                    this.paddingLength -= size;
                    if (this.paddingLength != 0) continue block8;
                    this.reset();
                    return true;
                }
            }
            throw new IllegalStateException();
        }
        return false;
    }

    private void onPushPromise(MetaData.Request metaData) {
        PushPromiseFrame frame = new PushPromiseFrame(this.getStreamId(), this.streamId, metaData);
        this.onPushPromise(frame);
    }

    private void onPushPromise(PushPromiseFrame frame) {
        this.notifyPushPromise(frame);
    }

    private static enum State {
        PREPARE,
        PADDING_LENGTH,
        STREAM_ID,
        STREAM_ID_BYTES,
        HEADERS,
        PADDING;

    }
}

