/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.generator;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http2.frames.FrameType;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.BufferUtil;

public class HeaderGenerator {
    private int maxFrameSize = 16384;
    private final ByteBufferPool bufferPool;
    private final boolean useDirectByteBuffers;

    public HeaderGenerator(ByteBufferPool bufferPool) {
        this(bufferPool, true);
    }

    public HeaderGenerator(ByteBufferPool bufferPool, boolean useDirectByteBuffers) {
        this.bufferPool = bufferPool;
        this.useDirectByteBuffers = useDirectByteBuffers;
    }

    public ByteBufferPool getByteBufferPool() {
        return this.bufferPool;
    }

    public boolean isUseDirectByteBuffers() {
        return this.useDirectByteBuffers;
    }

    public RetainableByteBuffer generate(FrameType frameType, int capacity, int length, int flags, int streamId) {
        RetainableByteBuffer buffer = this.getByteBufferPool().acquire(capacity, this.isUseDirectByteBuffers());
        ByteBuffer header = buffer.getByteBuffer();
        BufferUtil.clearToFill((ByteBuffer)header);
        header.put((byte)((length & 0xFF0000) >>> 16));
        header.put((byte)((length & 0xFF00) >>> 8));
        header.put((byte)(length & 0xFF));
        header.put((byte)frameType.getType());
        header.put((byte)flags);
        header.putInt(streamId);
        return buffer;
    }

    public int getMaxFrameSize() {
        return this.maxFrameSize;
    }

    public void setMaxFrameSize(int maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
    }
}

