/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.nifi.processors.standard.db;

import org.apache.nifi.processors.standard.db.impl.PatternNormalizer;
import org.apache.nifi.processors.standard.db.impl.RemoveAllSpecialCharNormalizer;
import org.apache.nifi.processors.standard.db.impl.RemoveSpaceNormalizer;
import org.apache.nifi.processors.standard.db.impl.RemoveUnderscoreAndSpaceNormalizer;
import org.apache.nifi.processors.standard.db.impl.RemoveUnderscoreNormalizer;

import java.util.regex.Pattern;

public class NameNormalizerFactory {
    public static NameNormalizer getNormalizer(TranslationStrategy strategy, Pattern regex) {

        return switch (strategy) {
            case REMOVE_UNDERSCORE -> new RemoveUnderscoreNormalizer();
            case REMOVE_SPACE -> new RemoveSpaceNormalizer();
            case REMOVE_UNDERSCORE_AND_SPACE -> new RemoveUnderscoreAndSpaceNormalizer();
            case REMOVE_ALL_SPECIAL_CHAR -> new RemoveAllSpecialCharNormalizer();
            case PATTERN -> new PatternNormalizer(regex);
        };
    }
}
