/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stream.io.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import org.apache.nifi.stream.io.util.AbstractTextDemarcator;

public class LineDemarcator
extends AbstractTextDemarcator {
    private static final char CARRIAGE_RETURN = '\r';
    private static final char NEW_LINE = '\n';
    private char lastChar;

    public LineDemarcator(InputStream in, Charset charset, int maxDataSize, int initialBufferSize) {
        this(new InputStreamReader(in, charset), maxDataSize, initialBufferSize);
    }

    public LineDemarcator(Reader reader, int maxDataSize, int initialBufferSize) {
        super(reader, maxDataSize, initialBufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String nextLine() throws IOException {
        while (this.availableBytesLength != -1) {
            if (this.index >= this.availableBytesLength) {
                this.fill();
            }
            if (this.availableBytesLength != -1) {
                int i;
                for (i = this.index; i < this.availableBytesLength; ++i) {
                    char charVal = this.buffer[i];
                    try {
                        if (charVal == '\n') {
                            this.index = i + 1;
                            int size = this.index - this.mark;
                            String line = new String(this.buffer, this.mark, size);
                            this.mark = this.index;
                            String string = line;
                            return string;
                        }
                        if (this.lastChar != '\r') continue;
                        this.index = i + 1;
                        int size = this.index - 1 - this.mark;
                        String line = new String(this.buffer, this.mark, size);
                        this.mark = this.index - 1;
                        String string = line;
                        return string;
                    }
                    finally {
                        this.lastChar = charVal;
                    }
                }
                this.index = i;
                continue;
            }
            int size = this.index - this.mark;
            if (size == 0) {
                return null;
            }
            return new String(this.buffer, this.mark, size);
        }
        return null;
    }
}

