/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote.util;

import org.apache.nifi.events.EventReporter;
import org.apache.nifi.reporting.Severity;
import org.slf4j.Logger;
import org.slf4j.helpers.MessageFormatter;

public class EventReportUtil {
    private static final String CATEGORY = "Site-to-Site";

    public static void warn(Logger logger, EventReporter eventReporter, String msg, Object ... args) {
        logger.warn(msg, args);
        if (eventReporter != null) {
            eventReporter.reportEvent(Severity.WARNING, CATEGORY, MessageFormatter.arrayFormat((String)msg, (Object[])args).getMessage());
        }
    }

    public static void warn(Logger logger, EventReporter eventReporter, String msg, Throwable t) {
        logger.warn(msg, t);
        if (eventReporter != null) {
            eventReporter.reportEvent(Severity.WARNING, CATEGORY, msg + ": " + t.toString());
        }
    }

    public static void error(Logger logger, EventReporter eventReporter, String msg, Object ... args) {
        logger.error(msg, args);
        if (eventReporter != null) {
            eventReporter.reportEvent(Severity.ERROR, CATEGORY, MessageFormatter.arrayFormat((String)msg, (Object[])args).getMessage());
        }
    }
}

