/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.dto.status;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Date;
import java.util.List;
import org.apache.nifi.web.api.dto.status.NodePortStatusSnapshotDTO;
import org.apache.nifi.web.api.dto.status.PortStatusSnapshotDTO;
import org.apache.nifi.web.api.dto.util.TimeAdapter;

@XmlType(name="portStatus")
public class PortStatusDTO {
    private String id;
    private String groupId;
    private String name;
    private Boolean transmitting;
    private String runStatus;
    private Date statsLastRefreshed;
    private PortStatusSnapshotDTO aggregateSnapshot;
    private List<NodePortStatusSnapshotDTO> nodeSnapshots;

    @Schema(description="Whether the port has incoming or outgoing connections to a remote NiFi.")
    public Boolean isTransmitting() {
        return this.transmitting;
    }

    public void setTransmitting(Boolean transmitting) {
        this.transmitting = transmitting;
    }

    @Schema(description="The id of the port.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Schema(description="The id of the parent process group of the port.")
    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @Schema(description="The name of the port.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Schema(description="The run status of the port.", allowableValues={"Running", "Stopped", "Validating", "Disabled", "Invalid"})
    public String getRunStatus() {
        return this.runStatus;
    }

    public void setRunStatus(String runStatus) {
        this.runStatus = runStatus;
    }

    @Schema(description="A status snapshot that represents the aggregate stats of all nodes in the cluster. If the NiFi instance is a standalone instance, rather than a cluster, this represents the stats of the single instance.")
    public PortStatusSnapshotDTO getAggregateSnapshot() {
        return this.aggregateSnapshot;
    }

    public void setAggregateSnapshot(PortStatusSnapshotDTO aggregateSnapshot) {
        this.aggregateSnapshot = aggregateSnapshot;
    }

    @Schema(description="A status snapshot for each node in the cluster. If the NiFi instance is a standalone instance, rather than a cluster, this may be null.")
    public List<NodePortStatusSnapshotDTO> getNodeSnapshots() {
        return this.nodeSnapshots;
    }

    public void setNodeSnapshots(List<NodePortStatusSnapshotDTO> nodeSnapshots) {
        this.nodeSnapshots = nodeSnapshots;
    }

    @XmlJavaTypeAdapter(value=TimeAdapter.class)
    @Schema(description="The time the status for the process group was last refreshed.", type="string")
    public Date getStatsLastRefreshed() {
        return this.statsLastRefreshed;
    }

    public void setStatsLastRefreshed(Date statsLastRefreshed) {
        this.statsLastRefreshed = statsLastRefreshed;
    }
}

