/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.text.translate.AggregateTranslator;
import org.apache.commons.text.translate.CharSequenceTranslator;
import org.apache.commons.text.translate.LookupTranslator;
import org.apache.commons.text.translate.UnicodeUnpairedSurrogateRemover;

public class CharacterFilterUtils {
    private static final List<String> INVALID_XML_CHARACTERS = Arrays.asList("\u0000", "\u0001", "\u0002", "\u0003", "\u0004", "\u0005", "\u0006", "\u0007", "\b", "\u000b", "\f", "\u000e", "\u000f", "\u0010", "\u0011", "\u0012", "\u0013", "\u0014", "\u0015", "\u0016", "\u0017", "\u0018", "\u0019", "\u001a", "\u001b", "\u001c", "\u001d", "\u001e", "\u001f", "\ufffe", "\uffff");
    private static final Map<CharSequence, CharSequence> INVALID_XML_CHARACTER_MAPPING = INVALID_XML_CHARACTERS.stream().collect(Collectors.toMap(invalidXmlCharacter -> invalidXmlCharacter, invalidXmlCharacter -> ""));
    private static final CharSequenceTranslator INVALID_XML_CHARACTER_FILTER = new AggregateTranslator(new CharSequenceTranslator[]{new LookupTranslator(INVALID_XML_CHARACTER_MAPPING), new UnicodeUnpairedSurrogateRemover()});

    public static String filterInvalidXmlCharacters(String value) {
        if (value == null) {
            return null;
        }
        return INVALID_XML_CHARACTER_FILTER.translate((CharSequence)value);
    }
}

