/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.flow.mapping;

import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;

public interface ComponentIdLookup {
    public static final Function<String, String> DEFAULT_VERSIONED_UUID_GENERATOR = componentId -> UUID.nameUUIDFromBytes(componentId.getBytes(StandardCharsets.UTF_8)).toString();
    public static final ComponentIdLookup VERSIONED_OR_GENERATE = new ComponentIdLookup(){

        @Override
        public String getComponentId(Optional<String> currentVersionedId, String componentId, Function<String, String> versionedUuidGenerator) {
            if (currentVersionedId.isPresent()) {
                return currentVersionedId.get();
            }
            return versionedUuidGenerator.apply(componentId);
        }
    };
    public static final ComponentIdLookup USE_COMPONENT_ID = (versioned, componentId, versionedUuidGenerator) -> componentId;

    default public String getComponentId(Optional<String> currentVersionedId, String componentId) {
        return this.getComponentId(currentVersionedId, componentId, DEFAULT_VERSIONED_UUID_GENERATOR);
    }

    public String getComponentId(Optional<String> var1, String var2, Function<String, String> var3);
}

