/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.flow;

import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.connectable.Funnel;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.controller.FlowAnalysisRuleNode;
import org.apache.nifi.controller.ParameterProviderNode;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.exception.ProcessorInstantiationException;
import org.apache.nifi.controller.flowanalysis.FlowAnalyzer;
import org.apache.nifi.controller.label.Label;
import org.apache.nifi.controller.parameter.ParameterProviderLookup;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.flowfile.FlowFilePrioritizer;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.groups.RemoteProcessGroup;
import org.apache.nifi.parameter.Parameter;
import org.apache.nifi.parameter.ParameterContext;
import org.apache.nifi.parameter.ParameterContextManager;
import org.apache.nifi.parameter.ParameterProviderConfiguration;
import org.apache.nifi.registry.flow.FlowRegistryClientNode;
import org.apache.nifi.validation.RuleViolationsManager;
import org.apache.nifi.web.api.dto.FlowSnippetDTO;

public interface FlowManager
extends ParameterProviderLookup {
    public static final String ROOT_GROUP_ID_ALIAS = "root";
    public static final String DEFAULT_ROOT_GROUP_NAME = "NiFi Flow";

    public Port createPublicInputPort(String var1, String var2);

    public Port createPublicOutputPort(String var1, String var2);

    public Set<Port> getPublicInputPorts();

    public Set<Port> getPublicOutputPorts();

    public Optional<Port> getPublicInputPort(String var1);

    public Optional<Port> getPublicOutputPort(String var1);

    public RemoteProcessGroup createRemoteProcessGroup(String var1, String var2);

    public ProcessGroup getRootGroup();

    public String getRootGroupId();

    public void instantiateSnippet(ProcessGroup var1, FlowSnippetDTO var2) throws ProcessorInstantiationException;

    public boolean areGroupsSame(String var1, String var2);

    public FlowFilePrioritizer createPrioritizer(String var1) throws InstantiationException, IllegalAccessException, ClassNotFoundException;

    public ProcessGroup getGroup(String var1);

    public void onProcessGroupAdded(ProcessGroup var1);

    public void onProcessGroupRemoved(ProcessGroup var1);

    public Connectable findConnectable(String var1);

    public ProcessorNode getProcessorNode(String var1);

    public void onProcessorAdded(ProcessorNode var1);

    public void onProcessorRemoved(ProcessorNode var1);

    public Set<ProcessorNode> findAllProcessors(Predicate<ProcessorNode> var1);

    public ProcessorNode createProcessor(String var1, String var2, BundleCoordinate var3);

    public ProcessorNode createProcessor(String var1, String var2, BundleCoordinate var3, boolean var4);

    public ProcessorNode createProcessor(String var1, String var2, BundleCoordinate var3, Set<URL> var4, boolean var5, boolean var6, String var7);

    public Label createLabel(String var1, String var2);

    public Funnel createFunnel(String var1);

    public Port createLocalInputPort(String var1, String var2);

    public Port createLocalOutputPort(String var1, String var2);

    public ProcessGroup createProcessGroup(String var1);

    public void onConnectionAdded(Connection var1);

    public void onConnectionRemoved(Connection var1);

    public Connection getConnection(String var1);

    public Set<Connection> findAllConnections();

    public Connection createConnection(String var1, String var2, Connectable var3, Connectable var4, Collection<String> var5);

    public void onInputPortAdded(Port var1);

    public void onInputPortRemoved(Port var1);

    public Port getInputPort(String var1);

    public void onOutputPortAdded(Port var1);

    public void onOutputPortRemoved(Port var1);

    public Port getOutputPort(String var1);

    public void onFunnelAdded(Funnel var1);

    public void onFunnelRemoved(Funnel var1);

    public Funnel getFunnel(String var1);

    public ReportingTaskNode createReportingTask(String var1, BundleCoordinate var2);

    public ReportingTaskNode createReportingTask(String var1, BundleCoordinate var2, boolean var3);

    public ReportingTaskNode createReportingTask(String var1, String var2, BundleCoordinate var3, boolean var4);

    public ReportingTaskNode createReportingTask(String var1, String var2, BundleCoordinate var3, Set<URL> var4, boolean var5, boolean var6, String var7);

    public ReportingTaskNode getReportingTaskNode(String var1);

    public void removeReportingTask(ReportingTaskNode var1);

    public Set<ReportingTaskNode> getAllReportingTasks();

    public ParameterProviderNode createParameterProvider(String var1, String var2, BundleCoordinate var3, Set<URL> var4, boolean var5, boolean var6);

    public ParameterProviderNode createParameterProvider(String var1, String var2, BundleCoordinate var3, boolean var4);

    public void removeParameterProvider(ParameterProviderNode var1);

    public Set<ParameterProviderNode> getAllParameterProviders();

    public FlowRegistryClientNode createFlowRegistryClient(String var1, String var2, BundleCoordinate var3, Set<URL> var4, boolean var5, boolean var6, String var7);

    public FlowRegistryClientNode getFlowRegistryClient(String var1);

    public void removeFlowRegistryClient(FlowRegistryClientNode var1);

    public Set<FlowRegistryClientNode> getAllFlowRegistryClients();

    public Set<ControllerServiceNode> getAllControllerServices();

    public ControllerServiceNode getControllerServiceNode(String var1);

    public ControllerServiceNode createControllerService(String var1, String var2, BundleCoordinate var3, Set<URL> var4, boolean var5, boolean var6, String var7);

    public Set<ControllerServiceNode> getRootControllerServices();

    public void addRootControllerService(ControllerServiceNode var1);

    public ControllerServiceNode getRootControllerService(String var1);

    public void removeRootControllerService(ControllerServiceNode var1);

    public ParameterContext createParameterContext(String var1, String var2, String var3, Map<String, Parameter> var4, List<String> var5, ParameterProviderConfiguration var6);

    public void withParameterContextResolution(Runnable var1);

    public ParameterContextManager getParameterContextManager();

    public Map<String, Integer> getComponentCounts();

    public void purge();

    public FlowAnalysisRuleNode createFlowAnalysisRule(String var1, String var2, BundleCoordinate var3, boolean var4);

    public FlowAnalysisRuleNode createFlowAnalysisRule(String var1, String var2, BundleCoordinate var3, Set<URL> var4, boolean var5, boolean var6, String var7);

    public FlowAnalysisRuleNode getFlowAnalysisRuleNode(String var1);

    public void removeFlowAnalysisRule(FlowAnalysisRuleNode var1);

    public Set<FlowAnalysisRuleNode> getAllFlowAnalysisRules();

    public Optional<FlowAnalyzer> getFlowAnalyzer();

    public Optional<RuleViolationsManager> getRuleViolationsManager();
}

