/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.flowanalysis;

import java.util.Optional;
import java.util.StringJoiner;
import org.apache.nifi.flow.VersionedComponent;
import org.apache.nifi.flowanalysis.AbstractAnalysisResult;

public class GroupAnalysisResult
extends AbstractAnalysisResult {
    private final Optional<VersionedComponent> component;

    private GroupAnalysisResult(String issueId, String message, String explanation, Optional<VersionedComponent> component) {
        super(issueId, message, explanation);
        this.component = component;
    }

    public Optional<VersionedComponent> getComponent() {
        return this.component;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", this.getClass().getSimpleName() + "[", "]").add("issueId='" + this.issueId + "'").add("message='" + this.message + "'").add("explanation='" + this.explanation + "'").add("component='" + String.valueOf(this.component) + "'").toString();
    }

    public static Builder forGroup(String issueId, String message) {
        return new Builder(null, issueId, message);
    }

    public static Builder forComponent(VersionedComponent component, String issueId, String message) {
        return new Builder(component, issueId, message);
    }

    public static class Builder {
        private final VersionedComponent component;
        private final String issueId;
        private final String message;
        private String explanation;

        private Builder(VersionedComponent component, String issueId, String message) {
            this.component = component;
            this.issueId = issueId;
            this.message = message;
        }

        public Builder explanation(String explanation) {
            this.explanation = explanation;
            return this;
        }

        public GroupAnalysisResult build() {
            return new GroupAnalysisResult(this.issueId, this.message, this.explanation, Optional.ofNullable(this.component));
        }
    }
}

