/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.flow;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.apache.nifi.flow.BatchSize;
import org.apache.nifi.flow.ComponentType;
import org.apache.nifi.flow.ScheduledState;
import org.apache.nifi.flow.VersionedComponent;

public class VersionedRemoteGroupPort
extends VersionedComponent {
    private String remoteGroupId;
    private Integer concurrentlySchedulableTaskCount;
    private Boolean useCompression;
    private BatchSize batchSize;
    private ComponentType componentType;
    private String targetId;
    private ScheduledState scheduledState;

    @Schema(description="The number of task that may transmit flowfiles to the target port concurrently.")
    public Integer getConcurrentlySchedulableTaskCount() {
        return this.concurrentlySchedulableTaskCount;
    }

    public void setConcurrentlySchedulableTaskCount(Integer concurrentlySchedulableTaskCount) {
        this.concurrentlySchedulableTaskCount = concurrentlySchedulableTaskCount;
    }

    @Schema(description="The id of the remote process group that the port resides in.")
    public String getRemoteGroupId() {
        return this.remoteGroupId;
    }

    public void setRemoteGroupId(String groupId) {
        this.remoteGroupId = groupId;
    }

    @Schema(description="Whether the flowfiles are compressed when sent to the target port.")
    public Boolean isUseCompression() {
        return this.useCompression;
    }

    public void setUseCompression(Boolean useCompression) {
        this.useCompression = useCompression;
    }

    @Schema(description="The batch settings for data transmission.")
    public BatchSize getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(BatchSize batchSize) {
        this.batchSize = batchSize;
    }

    @Schema(description="The ID of the port on the target NiFi instance")
    public String getTargetId() {
        return this.targetId;
    }

    public void setTargetId(String targetId) {
        this.targetId = targetId;
    }

    @Schema(description="The scheduled state of the component")
    public ScheduledState getScheduledState() {
        return this.scheduledState;
    }

    public void setScheduledState(ScheduledState scheduledState) {
        this.scheduledState = scheduledState;
    }

    @Override
    public int hashCode() {
        return 923847 + String.valueOf(this.getName()).hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VersionedRemoteGroupPort)) {
            return false;
        }
        VersionedRemoteGroupPort other = (VersionedRemoteGroupPort)obj;
        return Objects.equals(this.getName(), other.getName());
    }

    @Override
    public ComponentType getComponentType() {
        return this.componentType;
    }

    @Override
    public void setComponentType(ComponentType componentType) {
        if (componentType != ComponentType.REMOTE_INPUT_PORT && componentType != ComponentType.REMOTE_OUTPUT_PORT) {
            throw new IllegalArgumentException();
        }
        this.componentType = componentType;
    }
}

