/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.flow;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.HashSet;
import java.util.Set;
import org.apache.nifi.flow.ComponentType;
import org.apache.nifi.flow.ExecutionEngine;
import org.apache.nifi.flow.ScheduledState;
import org.apache.nifi.flow.VersionedComponent;
import org.apache.nifi.flow.VersionedConnection;
import org.apache.nifi.flow.VersionedControllerService;
import org.apache.nifi.flow.VersionedFlowCoordinates;
import org.apache.nifi.flow.VersionedFunnel;
import org.apache.nifi.flow.VersionedLabel;
import org.apache.nifi.flow.VersionedPort;
import org.apache.nifi.flow.VersionedProcessor;
import org.apache.nifi.flow.VersionedRemoteProcessGroup;

public class VersionedProcessGroup
extends VersionedComponent {
    private Set<VersionedProcessGroup> processGroups = new HashSet<VersionedProcessGroup>();
    private Set<VersionedRemoteProcessGroup> remoteProcessGroups = new HashSet<VersionedRemoteProcessGroup>();
    private Set<VersionedProcessor> processors = new HashSet<VersionedProcessor>();
    private Set<VersionedPort> inputPorts = new HashSet<VersionedPort>();
    private Set<VersionedPort> outputPorts = new HashSet<VersionedPort>();
    private Set<VersionedConnection> connections = new HashSet<VersionedConnection>();
    private Set<VersionedLabel> labels = new HashSet<VersionedLabel>();
    private Set<VersionedFunnel> funnels = new HashSet<VersionedFunnel>();
    private Set<VersionedControllerService> controllerServices = new HashSet<VersionedControllerService>();
    private VersionedFlowCoordinates versionedFlowCoordinates = null;
    private String parameterContextName;
    private String flowfileConcurrency;
    private String flowfileOutboundPolicy;
    private String defaultFlowFileExpiration;
    private Long defaultBackPressureObjectThreshold;
    private String defaultBackPressureDataSizeThreshold;
    private ScheduledState scheduledState;
    private ExecutionEngine executionEngine;
    private Integer maxConcurrentTasks;
    private String statelessFlowTimeout;
    private String logFileSuffix;

    @Schema(description="The child Process Groups")
    public Set<VersionedProcessGroup> getProcessGroups() {
        return this.processGroups;
    }

    public void setProcessGroups(Set<VersionedProcessGroup> processGroups) {
        this.processGroups = new HashSet<VersionedProcessGroup>(processGroups);
    }

    @Schema(description="The Remote Process Groups")
    public Set<VersionedRemoteProcessGroup> getRemoteProcessGroups() {
        return this.remoteProcessGroups;
    }

    public void setRemoteProcessGroups(Set<VersionedRemoteProcessGroup> remoteProcessGroups) {
        this.remoteProcessGroups = new HashSet<VersionedRemoteProcessGroup>(remoteProcessGroups);
    }

    @Schema(description="The Processors")
    public Set<VersionedProcessor> getProcessors() {
        return this.processors;
    }

    public void setProcessors(Set<VersionedProcessor> processors) {
        this.processors = new HashSet<VersionedProcessor>(processors);
    }

    @Schema(description="The Input Ports")
    public Set<VersionedPort> getInputPorts() {
        return this.inputPorts;
    }

    public void setInputPorts(Set<VersionedPort> inputPorts) {
        this.inputPorts = new HashSet<VersionedPort>(inputPorts);
    }

    @Schema(description="The Output Ports")
    public Set<VersionedPort> getOutputPorts() {
        return this.outputPorts;
    }

    public void setOutputPorts(Set<VersionedPort> outputPorts) {
        this.outputPorts = new HashSet<VersionedPort>(outputPorts);
    }

    @Schema(description="The Connections")
    public Set<VersionedConnection> getConnections() {
        return this.connections;
    }

    public void setConnections(Set<VersionedConnection> connections) {
        this.connections = new HashSet<VersionedConnection>(connections);
    }

    @Schema(description="The Labels")
    public Set<VersionedLabel> getLabels() {
        return this.labels;
    }

    public void setLabels(Set<VersionedLabel> labels) {
        this.labels = new HashSet<VersionedLabel>(labels);
    }

    @Schema(description="The Funnels")
    public Set<VersionedFunnel> getFunnels() {
        return this.funnels;
    }

    public void setFunnels(Set<VersionedFunnel> funnels) {
        this.funnels = new HashSet<VersionedFunnel>(funnels);
    }

    @Schema(description="The Controller Services")
    public Set<VersionedControllerService> getControllerServices() {
        return this.controllerServices;
    }

    public void setControllerServices(Set<VersionedControllerService> controllerServices) {
        this.controllerServices = new HashSet<VersionedControllerService>(controllerServices);
    }

    @Override
    public ComponentType getComponentType() {
        return ComponentType.PROCESS_GROUP;
    }

    public void setVersionedFlowCoordinates(VersionedFlowCoordinates flowCoordinates) {
        this.versionedFlowCoordinates = flowCoordinates;
    }

    @Schema(description="The coordinates where the remote flow is stored, or null if the Process Group is not directly under Version Control")
    public VersionedFlowCoordinates getVersionedFlowCoordinates() {
        return this.versionedFlowCoordinates;
    }

    @Schema(description="The name of the parameter context used by this process group")
    public String getParameterContextName() {
        return this.parameterContextName;
    }

    public void setParameterContextName(String parameterContextName) {
        this.parameterContextName = parameterContextName;
    }

    @Schema(description="The configured FlowFile Concurrency for the Process Group")
    public String getFlowFileConcurrency() {
        return this.flowfileConcurrency;
    }

    public void setFlowFileConcurrency(String flowfileConcurrency) {
        this.flowfileConcurrency = flowfileConcurrency;
    }

    @Schema(description="The FlowFile Outbound Policy for the Process Group")
    public String getFlowFileOutboundPolicy() {
        return this.flowfileOutboundPolicy;
    }

    public void setFlowFileOutboundPolicy(String outboundPolicy) {
        this.flowfileOutboundPolicy = outboundPolicy;
    }

    @Schema(description="The default FlowFile Expiration for this Process Group.")
    public String getDefaultFlowFileExpiration() {
        return this.defaultFlowFileExpiration;
    }

    public void setDefaultFlowFileExpiration(String defaultFlowFileExpiration) {
        this.defaultFlowFileExpiration = defaultFlowFileExpiration;
    }

    @Schema(description="Default value used in this Process Group for the maximum number of objects that can be queued before back pressure is applied.")
    public Long getDefaultBackPressureObjectThreshold() {
        return this.defaultBackPressureObjectThreshold;
    }

    public void setDefaultBackPressureObjectThreshold(Long defaultBackPressureObjectThreshold) {
        this.defaultBackPressureObjectThreshold = defaultBackPressureObjectThreshold;
    }

    @Schema(description="Default value used in this Process Group for the maximum data size of objects that can be queued before back pressure is applied.")
    public String getDefaultBackPressureDataSizeThreshold() {
        return this.defaultBackPressureDataSizeThreshold;
    }

    public void setDefaultBackPressureDataSizeThreshold(String defaultBackPressureDataSizeThreshold) {
        this.defaultBackPressureDataSizeThreshold = defaultBackPressureDataSizeThreshold;
    }

    @Schema(description="The log file suffix for this Process Group for dedicated logging.")
    public String getLogFileSuffix() {
        return this.logFileSuffix;
    }

    public void setLogFileSuffix(String logFileSuffix) {
        this.logFileSuffix = logFileSuffix;
    }

    @Schema(description="The Scheduled State of the Process Group, if the group is configured to use the Stateless Execution Engine. Otherwise, this value has no relevance.")
    public ScheduledState getScheduledState() {
        return this.scheduledState;
    }

    public void setScheduledState(ScheduledState scheduledState) {
        this.scheduledState = scheduledState;
    }

    @Schema(description="The Execution Engine that should be used to run the components within the group.")
    public ExecutionEngine getExecutionEngine() {
        return this.executionEngine;
    }

    public void setExecutionEngine(ExecutionEngine executionEngine) {
        this.executionEngine = executionEngine;
    }

    @Schema(description="The maximum number of concurrent tasks that should be scheduled for this Process Group when using the Stateless Engine")
    public Integer getMaxConcurrentTasks() {
        return this.maxConcurrentTasks;
    }

    public void setMaxConcurrentTasks(Integer maxConcurrentTasks) {
        this.maxConcurrentTasks = maxConcurrentTasks;
    }

    @Schema(description="The maximum amount of time that the flow is allows to run using the Stateless engine before it times out and is considered a failure")
    public String getStatelessFlowTimeout() {
        return this.statelessFlowTimeout;
    }

    public void setStatelessFlowTimeout(String timeout) {
        this.statelessFlowTimeout = timeout;
    }
}

