/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote.client;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.apache.nifi.remote.client.AbstractPeerPersistence;
import org.apache.nifi.remote.util.PeerStatusCache;

public class FilePeerPersistence
extends AbstractPeerPersistence {
    private final File persistenceFile;

    public FilePeerPersistence(File persistenceFile) {
        this.persistenceFile = persistenceFile;
    }

    @Override
    public void save(PeerStatusCache peerStatusCache) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(this.persistenceFile);
             BufferedOutputStream out = new BufferedOutputStream(fos);){
            this.write(peerStatusCache, line -> out.write(line.getBytes(StandardCharsets.UTF_8)));
        }
    }

    @Override
    public PeerStatusCache restore() throws IOException {
        try (FileInputStream fis = new FileInputStream(this.persistenceFile);){
            PeerStatusCache peerStatusCache;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(fis));){
                peerStatusCache = this.restorePeerStatuses(reader, this.persistenceFile.lastModified());
            }
            return peerStatusCache;
        }
    }
}

