/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.queue;

import org.apache.nifi.controller.queue.DropFlowFileState;
import org.apache.nifi.controller.queue.DropFlowFileStatus;
import org.apache.nifi.controller.queue.QueueSize;

public class DropFlowFileRequest
implements DropFlowFileStatus {
    private final String identifier;
    private final long submissionTime = System.currentTimeMillis();
    private volatile QueueSize originalSize;
    private volatile QueueSize currentSize;
    private volatile QueueSize droppedSize = new QueueSize(0, 0L);
    private volatile long lastUpdated = System.currentTimeMillis();
    private volatile String failureReason;
    private DropFlowFileState state = DropFlowFileState.WAITING_FOR_LOCK;

    public DropFlowFileRequest(String identifier) {
        this.identifier = identifier;
    }

    public String getRequestIdentifier() {
        return this.identifier;
    }

    public long getRequestSubmissionTime() {
        return this.submissionTime;
    }

    public QueueSize getOriginalSize() {
        return this.originalSize;
    }

    public void setOriginalSize(QueueSize originalSize) {
        this.originalSize = originalSize;
    }

    public QueueSize getCurrentSize() {
        return this.currentSize;
    }

    public void setCurrentSize(QueueSize queueSize) {
        this.currentSize = queueSize;
    }

    public QueueSize getDroppedSize() {
        return this.droppedSize;
    }

    public void setDroppedSize(QueueSize droppedSize) {
        this.droppedSize = droppedSize;
    }

    public synchronized DropFlowFileState getState() {
        return this.state;
    }

    public long getLastUpdated() {
        return this.lastUpdated;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public synchronized void setState(DropFlowFileState state) {
        this.setState(state, null);
    }

    public synchronized void setState(DropFlowFileState state, String explanation) {
        this.state = state;
        this.failureReason = explanation;
        this.lastUpdated = System.currentTimeMillis();
    }

    public synchronized boolean cancel() {
        if (this.state == DropFlowFileState.COMPLETE || this.state == DropFlowFileState.CANCELED) {
            return false;
        }
        this.state = DropFlowFileState.CANCELED;
        return true;
    }
}

