/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.runtime;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.nifi.runtime.util.HttpExchangeUtils;

class HealthHttpHandler
implements HttpHandler {
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String TEXT_PLAIN = "text/plain";
    private static final int NO_RESPONSE_BODY = -1;
    private static final String GET_METHOD = "GET";
    private static final String STATUS_UP = "Status: UP\n";

    HealthHttpHandler() {
    }

    @Override
    public void handle(HttpExchange exchange) throws IOException {
        HttpExchangeUtils.drainRequestBody(exchange);
        String requestMethod = exchange.getRequestMethod();
        try (OutputStream responseBody = exchange.getResponseBody();){
            if (GET_METHOD.contentEquals(requestMethod)) {
                exchange.getResponseHeaders().set(CONTENT_TYPE_HEADER, TEXT_PLAIN);
                byte[] response = STATUS_UP.getBytes(StandardCharsets.UTF_8);
                exchange.sendResponseHeaders(200, response.length);
                responseBody.write(response);
            } else {
                exchange.sendResponseHeaders(405, -1L);
            }
        }
    }
}

